/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.security.authentication.plain.PlainSaslServer;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PlainSaslServerTest {
    private static byte sSEPARATOR = 0;
    private SaslServer mPlainSaslServer = null;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mPlainSaslServer = new PlainSaslServer.Factory().createSaslServer("PLAIN", null, null, null, (CallbackHandler)new MockCallbackHandler());
    }

    private byte[] getUserInfo(String user, String password) throws Exception {
        byte[] auth = user.getBytes("UTF8");
        byte[] pw = password.getBytes("UTF8");
        byte[] result = new byte[pw.length + auth.length + 2];
        int pos = 0;
        result[pos++] = sSEPARATOR;
        System.arraycopy(auth, 0, result, pos, auth.length);
        pos += auth.length;
        result[pos++] = sSEPARATOR;
        System.arraycopy(pw, 0, result, pos, pw.length);
        return result;
    }

    @Test
    public void userIsNotSet() throws Exception {
        this.mThrown.expect(SaslException.class);
        this.mThrown.expectMessage("Plain authentication failed: No authentication identity provided");
        this.mPlainSaslServer.evaluateResponse(this.getUserInfo("", "anonymous"));
    }

    @Test
    public void passwordIsNotSet() throws Exception {
        this.mThrown.expect(SaslException.class);
        this.mThrown.expectMessage("Plain authentication failed: No password provided");
        this.mPlainSaslServer.evaluateResponse(this.getUserInfo("alluxio", ""));
    }

    @Test
    public void authenticationNotComplete() {
        this.mThrown.expect(IllegalStateException.class);
        this.mThrown.expectMessage("PLAIN authentication not completed");
        this.mPlainSaslServer.getAuthorizationID();
    }

    @Test
    public void userPasswordReceive() throws Exception {
        String testUser = "alluxio";
        String password = "anonymous";
        this.mPlainSaslServer.evaluateResponse(this.getUserInfo(testUser, password));
        Assert.assertEquals((Object)testUser, (Object)this.mPlainSaslServer.getAuthorizationID());
    }

    @Test
    public void unauthorizedCallback() throws Exception {
        String testUser = "alluxio";
        String password = "anonymous";
        this.mPlainSaslServer = new PlainSaslServer.Factory().createSaslServer("PLAIN", null, null, null, (CallbackHandler)new MockCallbackHandlerUnauthorized());
        this.mThrown.expect(SaslException.class);
        this.mThrown.expectMessage("Plain authentication failed: AuthorizeCallback authorized failure");
        this.mPlainSaslServer.evaluateResponse(this.getUserInfo(testUser, password));
    }

    private static class MockCallbackHandlerUnauthorized
    implements CallbackHandler {
        private MockCallbackHandlerUnauthorized() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) continue;
                ac = (AuthorizeCallback)callback;
            }
            ac.setAuthorized(false);
        }
    }

    private static class MockCallbackHandler
    implements CallbackHandler {
        private MockCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) continue;
                ac = (AuthorizeCallback)callback;
            }
            ac.setAuthorized(true);
        }
    }
}

