/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.ImpersonationAuthenticator;
import alluxio.security.authentication.plain.PlainSaslServerCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PlainSaslServerCallbackHandlerTest {
    private CallbackHandler mPlainServerCBHandler;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();
    @Rule
    public ConfigurationRule mConfigurationRule = new ConfigurationRule(PropertyKey.SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS, NameMatchAuthenticationProvider.class.getName(), this.mConfiguration);

    @Before
    public void before() throws Exception {
        this.mPlainServerCBHandler = new PlainSaslServerCallbackHandler(AuthenticationProvider.Factory.create((AuthType)AuthType.CUSTOM, (AlluxioConfiguration)this.mConfiguration), new ImpersonationAuthenticator((AlluxioConfiguration)this.mConfiguration));
    }

    @After
    public void after() {
        AuthenticatedClientUser.remove();
    }

    @Test
    public void authenticateNameMatch() throws Exception {
        String authenticateId = "alluxio-1";
        NameCallback ncb = new NameCallback(" authentication id: ");
        ncb.setName(authenticateId);
        PasswordCallback pcb = new PasswordCallback(" password: ", false);
        pcb.setPassword("password".toCharArray());
        Callback[] callbacks = new Callback[]{ncb, pcb, new AuthorizeCallback(authenticateId, authenticateId)};
        this.mPlainServerCBHandler.handle(callbacks);
    }

    @Test
    public void authenticateNameNotMatch() throws Exception {
        this.mThrown.expect(AuthenticationException.class);
        this.mThrown.expectMessage("Only allow the user starting with alluxio");
        String authenticateId = "not-alluxio-1";
        NameCallback ncb = new NameCallback(" authentication id: ");
        ncb.setName(authenticateId);
        PasswordCallback pcb = new PasswordCallback(" password: ", false);
        pcb.setPassword("password".toCharArray());
        Callback[] callbacks = new Callback[]{ncb, pcb, new AuthorizeCallback(authenticateId, authenticateId)};
        this.mPlainServerCBHandler.handle(callbacks);
    }

    @Test
    public void authenticateCorrectPassword() throws Exception {
        this.mThrown.expect(AuthenticationException.class);
        this.mThrown.expectMessage("Wrong password");
        String authenticateId = "alluxio-1";
        NameCallback ncb = new NameCallback(" authentication id: ");
        ncb.setName(authenticateId);
        PasswordCallback pcb = new PasswordCallback(" password: ", false);
        pcb.setPassword("not-password".toCharArray());
        Callback[] callbacks = new Callback[]{ncb, pcb, new AuthorizeCallback(authenticateId, authenticateId)};
        this.mPlainServerCBHandler.handle(callbacks);
    }

    public static class NameMatchAuthenticationProvider
    implements AuthenticationProvider {
        public void authenticate(String user, String password) throws AuthenticationException {
            if (!user.matches("^alluxio.*")) {
                throw new AuthenticationException("Only allow the user starting with alluxio");
            }
            if (!password.matches("^password")) {
                throw new AuthenticationException("Wrong password");
            }
        }
    }
}

