/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.security.authentication.plain.PlainSaslClientCallbackHandler;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PlainSaslClientCallbackHandlerTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void clientCallbackHandler() throws Exception {
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", true)};
        String user = "alluxio-user-1";
        String password = "alluxio-user-1-password";
        PlainSaslClientCallbackHandler clientCBHandler = new PlainSaslClientCallbackHandler(user, password);
        clientCBHandler.handle(callbacks);
        this.validateCallbacks(user, password, callbacks);
    }

    @Test
    public void unsupportCallback() throws Exception {
        this.mThrown.expect(UnsupportedCallbackException.class);
        this.mThrown.expectMessage(RealmCallback.class + " is unsupported.");
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", true), new RealmCallback("Realm:")};
        String user = "alluxio-user-2";
        String password = "alluxio-user-2-password";
        PlainSaslClientCallbackHandler clientCBHandler = new PlainSaslClientCallbackHandler(user, password);
        clientCBHandler.handle(callbacks);
    }

    @Test
    public void nullNameCallback() throws Exception {
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", true)};
        String user = null;
        String password = "alluxio-user-3-password";
        PlainSaslClientCallbackHandler clientCBHandler = new PlainSaslClientCallbackHandler(user, password);
        clientCBHandler.handle(callbacks);
        this.validateCallbacks(user, password, callbacks);
    }

    @Test
    public void nullPasswordCallback() throws Exception {
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", true)};
        String user = "alluxio-user-4";
        String password = null;
        PlainSaslClientCallbackHandler clientCBHandler = new PlainSaslClientCallbackHandler(user, password);
        clientCBHandler.handle(callbacks);
        this.validateCallbacks(user, password, callbacks);
    }

    @Test
    public void nullCallback() throws Exception {
        this.mThrown.expect(UnsupportedCallbackException.class);
        this.mThrown.expectMessage(null + " is unsupported.");
        Callback[] callbacks = new Callback[]{new NameCallback("Username:"), new PasswordCallback("Password:", true), null};
        String user = "alluxio-user-5";
        String password = "alluxio-user-5-password";
        PlainSaslClientCallbackHandler clientCBHandler = new PlainSaslClientCallbackHandler(user, password);
        clientCBHandler.handle(callbacks);
    }

    private void validateCallbacks(String user, String passwd, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                Assert.assertEquals((Object)user, (Object)((NameCallback)cb).getName());
                continue;
            }
            if (!(cb instanceof PasswordCallback)) continue;
            char[] passwordChar = ((PasswordCallback)cb).getPassword();
            Assert.assertEquals((Object)passwd, (Object)(passwordChar == null ? null : String.copyValueOf(passwordChar)));
        }
    }
}

