/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcConnection;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.user.UserState;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.sasl.AuthenticationException;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.powermock.reflect.Whitebox;

public class GrpcSecurityTest {
    private static final int S_AUTHENTICATION_PROPOGATE_TIMEOUT = 30000;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    @Test
    public void testServerUnsupportedAuthentication() {
        this.mThrown.expect(RuntimeException.class);
        this.mThrown.expectMessage((Matcher)new StringStartsWith(false, "No factory could create a UserState with authType: " + AuthType.KERBEROS.name()));
        this.createServer(AuthType.KERBEROS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleAuthentication() throws Exception {
        GrpcServer server = this.createServer(AuthType.SIMPLE);
        try {
            server.start();
            UserState us = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration).setSubject(us.getSubject());
            channelBuilder.build();
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testNoSaslAuthentication() throws Exception {
        GrpcServer server = this.createServer(AuthType.NOSASL);
        try {
            server.start();
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration);
            channelBuilder.build();
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testCustomAuthentication() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.CUSTOM.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS, (Object)ExactlyMatchAuthenticationProvider.class.getName());
        GrpcServer server = this.createServer(AuthType.CUSTOM);
        try {
            server.start();
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration);
            channelBuilder.setSubject(this.createSubject("alluxio", "correct-password")).build();
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testCustomAuthenticationFails() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.CUSTOM.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS, (Object)ExactlyMatchAuthenticationProvider.class.getName());
        GrpcServer server = this.createServer(AuthType.CUSTOM);
        try {
            server.start();
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration);
            this.mThrown.expect(UnauthenticatedException.class);
            channelBuilder.setSubject(this.createSubject("fail", "fail")).build();
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testDisabledAuthentication() throws Exception {
        GrpcServer server = this.createServer(AuthType.SIMPLE);
        try {
            server.start();
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration);
            channelBuilder.disableAuthentication().build();
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testAuthMismatch() throws Exception {
        GrpcServer server = this.createServer(AuthType.NOSASL);
        try {
            server.start();
            this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE);
            GrpcChannelBuilder channelBuilder = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration);
            this.mThrown.expect(UnauthenticatedException.class);
            channelBuilder.build();
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationClosed() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        GrpcServer server = this.createServer(AuthType.SIMPLE);
        try {
            server.start();
            UserState us = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
            GrpcChannel channel = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration).setSubject(us.getSubject()).build();
            GrpcConnection connection = (GrpcConnection)Whitebox.getInternalState((Object)channel, (String)"mConnection");
            UUID channelId = connection.getChannelKey().getChannelId();
            Assert.assertNotNull((Object)server.getAuthenticationServer().getUserInfoForChannel(channelId));
            channel.shutdown();
            CommonUtils.waitFor((String)"login state removed", () -> {
                try {
                    server.getAuthenticationServer().getUserInfoForChannel(channelId);
                    return false;
                }
                catch (UnauthenticatedException exc) {
                    return true;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(30000));
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationRevoked() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.AUTHENTICATION_INACTIVE_CHANNEL_REAUTHENTICATE_PERIOD, (Object)"250ms");
        GrpcServer server = this.createServer(AuthType.SIMPLE);
        try {
            server.start();
            UserState us = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
            GrpcChannel channel = GrpcChannelBuilder.newBuilder((GrpcServerAddress)this.getServerConnectAddress(server), (AlluxioConfiguration)this.mConfiguration).setSubject(us.getSubject()).build();
            Assert.assertTrue((boolean)channel.isHealthy());
            Thread.sleep(500L);
            Assert.assertFalse((boolean)channel.isHealthy());
        }
        finally {
            server.shutdown();
        }
    }

    private GrpcServerAddress getServerConnectAddress(GrpcServer server) {
        return GrpcServerAddress.create((InetSocketAddress)new InetSocketAddress(NetworkAddressUtils.getLocalHostName((int)((int)this.mConfiguration.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))), server.getBindPort()));
    }

    private GrpcServer createServer(AuthType authType) {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)authType.name());
        InetSocketAddress bindAddress = new InetSocketAddress(NetworkAddressUtils.getLocalHostName((int)((int)this.mConfiguration.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))), 0);
        UserState us = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        GrpcServerBuilder serverBuilder = GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)"localhost", (SocketAddress)bindAddress), (AlluxioConfiguration)this.mConfiguration, (UserState)us);
        return serverBuilder.build();
    }

    private Subject createSubject(String username, String password) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new User(username));
        subject.getPrivateCredentials().add(password);
        return subject;
    }

    public static class ExactlyMatchAuthenticationProvider
    implements AuthenticationProvider {
        static final String USERNAME = "alluxio";
        static final String PASSWORD = "correct-password";

        public void authenticate(String user, String password) throws AuthenticationException {
            if (!user.equals(USERNAME) || !password.equals(PASSWORD)) {
                throw new AuthenticationException("User authentication fails");
            }
        }
    }
}

