/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.plain.CustomAuthenticationProvider;
import javax.security.sasl.AuthenticationException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class CustomAuthenticationProviderTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void classNotFound() {
        String notExistClass = "alluxio.test.custom.provider";
        this.mThrown.expect(RuntimeException.class);
        this.mThrown.expectMessage(notExistClass + " not found");
        new CustomAuthenticationProvider(notExistClass);
    }

    @Test
    public void classNotProvider() {
        String notProviderClass = CustomAuthenticationProviderTest.class.getName();
        this.mThrown.expect(RuntimeException.class);
        this.mThrown.expectMessage("alluxio.security.authentication.CustomAuthenticationProviderTest cannot be cast to ");
        this.mThrown.expectMessage("alluxio.security.authentication.AuthenticationProvider");
        new CustomAuthenticationProvider(notProviderClass);
    }

    @Test
    public void mockCustomProvider() {
        CustomAuthenticationProvider provider = new CustomAuthenticationProvider(MockAuthenticationProvider.class.getName());
        Assert.assertTrue((boolean)(provider.getCustomProvider() instanceof MockAuthenticationProvider));
    }

    public static class MockAuthenticationProvider
    implements AuthenticationProvider {
        public void authenticate(String user, String password) throws AuthenticationException {
        }
    }
}

