/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security;

import alluxio.security.User;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.junit.Assert;
import org.junit.Test;

public final class UserTest {
    @Test
    public void usedInSecurityContext() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new User("realUser"));
        subject.getPrincipals().add((Principal)new User("proxyUser"));
        Set<User> users = subject.getPrincipals(User.class);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertTrue((boolean)users.contains(new User("realUser")));
        Assert.assertFalse((boolean)users.contains(new User("noExistingUser")));
    }

    @Test
    public void realmAsUserName() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new User("admin/admin@EXAMPLE.com"));
        subject.getPrincipals().add((Principal)new User("admin/mbox.example.com@EXAMPLE.com"));
        subject.getPrincipals().add((Principal)new User("imap/mbox.example.com@EXAMPLE.COM"));
        Set<User> users = subject.getPrincipals(User.class);
        Assert.assertEquals((long)3L, (long)users.size());
        subject.getPrincipals().add((Principal)new User("admin"));
        subject.getPrincipals().add((Principal)new User("imap"));
        users = subject.getPrincipals(User.class);
        Assert.assertEquals((long)5L, (long)users.size());
    }
}

