/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class RetryUtilsTest {
    @Test
    public void success() throws IOException {
        AtomicInteger count = new AtomicInteger(0);
        RetryUtils.retry((String)"success test", () -> {
            count.incrementAndGet();
            if (count.get() == 5) {
                return;
            }
            throw new IOException("Fail");
        }, (RetryPolicy)new CountingRetry(10));
        Assert.assertEquals((long)5L, (long)count.get());
    }

    @Test
    public void failure() throws IOException {
        AtomicInteger count = new AtomicInteger(0);
        try {
            RetryUtils.retry((String)"failure test", () -> {
                count.incrementAndGet();
                throw new IOException(Integer.toString(count.get()));
            }, (RetryPolicy)new CountingRetry(10));
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"11", (Object)e.getMessage());
        }
        Assert.assertEquals((long)11L, (long)count.get());
    }
}

