/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.clock.ManualClock;
import alluxio.retry.ExponentialTimeBoundedRetry;
import alluxio.time.ManualSleeper;
import alluxio.time.Sleeper;
import alluxio.time.TimeContext;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public final class ExponentialTimeBoundedRetryTest {
    @Test
    public void exponentialBackoff() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            ManualClock clock = new ManualClock();
            ManualSleeper sleeper = new ManualSleeper();
            long maxDurationMs = 500L;
            long taskTimeMs = 20L;
            ExponentialTimeBoundedRetry retry = ExponentialTimeBoundedRetry.builder().withTimeCtx(new TimeContext((Clock)clock, (Sleeper)sleeper)).withMaxDuration(Duration.ofMillis(maxDurationMs)).withInitialSleep(Duration.ofMillis(10L)).withMaxSleep(Duration.ofMillis(100L)).build();
            Thread thread = new Thread(() -> {
                while (retry.attempt()) {
                    clock.addTimeMs(taskTimeMs);
                }
            });
            thread.setDaemon(true);
            thread.setName("time-bounded-exponential-backoff-test");
            thread.start();
            long timeRemainingMs = maxDurationMs - taskTimeMs;
            Iterator<Long> expectedBaseTimes = Arrays.asList(10L, 20L, 40L, 80L, 100L).iterator();
            long expectedTime = expectedBaseTimes.next();
            while (timeRemainingMs > 0L) {
                Duration actualSleep = sleeper.waitForSleep();
                this.checkBetween(expectedTime, (double)expectedTime * 1.1, actualSleep);
                timeRemainingMs -= actualSleep.toMillis() + taskTimeMs;
                clock.addTime(actualSleep);
                sleeper.wakeUp();
                if (expectedBaseTimes.hasNext()) {
                    expectedTime = expectedBaseTimes.next();
                }
                if (timeRemainingMs >= 100L) continue;
                expectedTime = timeRemainingMs;
            }
            thread.interrupt();
            thread.join(10000L);
            Assert.assertFalse((boolean)retry.attempt());
        }
    }

    private void checkBetween(double start, double end, Duration time) {
        Assert.assertThat((Object)time.toMillis(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(start)));
        Assert.assertThat((Object)time.toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(end)));
    }
}

