/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.ExponentialBackoffRetry;
import org.junit.Assert;
import org.junit.Test;

public final class ExponentialBackoffRetryTest {
    @Test
    public void largeRetriesProducePositiveTime() {
        int max = 1000;
        MockExponentialBackoffRetry backoff = new MockExponentialBackoffRetry(50, Integer.MAX_VALUE, max);
        for (int i = 0; i < max; ++i) {
            backoff.setRetryCount(i);
            long time = backoff.getSleepTime();
            Assert.assertTrue((String)("Time must always be positive: " + time), (time > 0L ? 1 : 0) != 0);
        }
    }

    public static final class MockExponentialBackoffRetry
    extends ExponentialBackoffRetry {
        private int mRetryCount = 0;

        public MockExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepMs, int maxRetries) {
            super(baseSleepTimeMs, maxSleepMs, maxRetries);
        }

        public int getAttemptCount() {
            return this.mRetryCount;
        }

        public void setRetryCount(int retryCount) {
            this.mRetryCount = retryCount;
        }
    }
}

