/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.ResourcePool;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public final class ResourcePoolTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void resourcePoolNormal() {
        TestResourcePool testPool = new TestResourcePool(2);
        int resource1 = (Integer)testPool.acquire();
        testPool.release(resource1);
        int resource2 = (Integer)testPool.acquire();
        Assert.assertEquals((long)resource1, (long)resource2);
    }

    @Test
    public void resourcePoolBlocking() throws InterruptedException {
        this.mThrown.expect(RuntimeException.class);
        int POOL_SIZE = 2;
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)Mockito.mock(ConcurrentLinkedQueue.class);
        TestResourcePool testPool = new TestResourcePool(2, queue);
        Mockito.when((Object)queue.isEmpty()).thenReturn((Object)true);
        Mockito.when(queue.poll()).thenThrow(new Throwable[]{new InterruptedException()});
        for (int i = 0; i < 3; ++i) {
            testPool.acquire();
        }
    }

    @Test
    public void resourcePoolTimestampOverflow() {
        Callable<Integer> task = () -> {
            ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)Mockito.mock(ConcurrentLinkedQueue.class);
            TestResourcePool testPool = new TestResourcePool(2, queue);
            Integer resource1 = (Integer)testPool.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            Integer resource2 = (Integer)testPool.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)new Integer(1), (Object)resource1);
            Assert.assertEquals((Object)new Integer(2), (Object)resource2);
            Integer resource3 = (Integer)testPool.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)resource3);
            return resource3;
        };
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Integer> future = executor.submit(task);
        boolean timeout = false;
        try {
            future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)future.isDone());
        future.cancel(true);
    }

    class TestResourcePool
    extends ResourcePool<Integer> {
        int mPort;

        public TestResourcePool(int maxCapacity) {
            super(maxCapacity);
            this.mPort = 0;
        }

        public TestResourcePool(int maxCapacity, ConcurrentLinkedQueue<Integer> resources) {
            super(maxCapacity, resources);
            this.mPort = 0;
        }

        public void close() {
        }

        protected Integer createNewResource() {
            ++this.mPort;
            return this.mPort;
        }
    }
}

