/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.LockResource;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.Assert;
import org.junit.Test;

public final class LockResourceTest {
    @Test
    public void reentrantLock() {
        ReentrantLock lock = new ReentrantLock();
        try (LockResource r1 = new LockResource((Lock)lock);
             LockResource r2 = new LockResource((Lock)lock);){
            Assert.assertTrue((boolean)lock.tryLock());
            lock.unlock();
        }
    }

    @Test
    public void reentrantTryLock() {
        ReentrantLock lock = new ReentrantLock();
        try (LockResource r1 = new LockResource((Lock)lock, true, true);
             LockResource r2 = new LockResource((Lock)lock, true, true);){
            Assert.assertTrue((boolean)lock.tryLock());
            lock.unlock();
        }
    }

    @Test
    public void reentrantReadWriteLock() {
        Throwable throwable;
        LockResource r2;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try (LockResource r1 = new LockResource((Lock)lock.readLock());){
            r2 = new LockResource((Lock)lock.readLock());
            throwable = null;
            try {
                Assert.assertEquals((long)lock.getReadHoldCount(), (long)2L);
                Assert.assertTrue((boolean)lock.readLock().tryLock());
                lock.readLock().unlock();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (r2 != null) {
                    if (throwable != null) {
                        try {
                            r2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        r2.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)lock.getReadHoldCount(), (long)0L);
        r1 = new LockResource((Lock)lock.writeLock());
        var3_3 = null;
        try {
            r2 = new LockResource((Lock)lock.readLock());
            throwable = null;
            try {
                Assert.assertTrue((boolean)lock.isWriteLockedByCurrentThread());
                Assert.assertEquals((long)lock.getReadHoldCount(), (long)1L);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (r2 != null) {
                    if (throwable != null) {
                        try {
                            r2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        r2.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (r1 != null) {
                if (var3_3 != null) {
                    try {
                        r1.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    r1.close();
                }
            }
        }
        Assert.assertFalse((boolean)lock.isWriteLockedByCurrentThread());
        Assert.assertEquals((long)lock.getReadHoldCount(), (long)0L);
        var3_3 = null;
        try (LockResource r = new LockResource((Lock)lock.readLock());){
            Assert.assertFalse((boolean)lock.writeLock().tryLock());
        }
        catch (Throwable throwable8) {
            var3_3 = throwable8;
            throw throwable8;
        }
    }
}

