/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.clock.ManualClock;
import alluxio.resource.DynamicResourcePool;
import alluxio.util.ThreadFactoryUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public final class DynamicResourcePoolTest {
    @Test
    public void acquireWithCapacity() throws Exception {
        int i;
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i2 = 0; i2 < 3; ++i2) {
            Resource resource = (Resource)pool.acquire();
            resourceList.add(resource);
            Assert.assertEquals((long)i2, (long)resource.mInteger.intValue());
        }
        for (Resource resource : resourceList) {
            pool.release(resource);
        }
        HashSet<Integer> resources = new HashSet<Integer>();
        for (i = 0; i < 3; ++i) {
            Resource resource = (Resource)pool.acquire();
            resources.add(resource.mInteger);
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)resources.contains(i));
        }
    }

    @Test
    public void acquireWithoutCapacity() throws Exception {
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(1));
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        boolean timeout = false;
        try {
            Resource resource = (Resource)pool.acquire();
            resourceList.add(resource);
            Assert.assertEquals((long)0L, (long)resource.mInteger.intValue());
            resource = (Resource)pool.acquire(1L, TimeUnit.SECONDS);
            resourceList.add(resource);
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertEquals((long)1L, (long)resourceList.size());
        Assert.assertTrue((boolean)timeout);
    }

    @Test
    public void UnhealthyResource() throws Exception {
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions());
        Resource resource = (Resource)pool.acquire();
        Assert.assertEquals((long)0L, (long)resource.mInteger.intValue());
        resource.setInteger(10);
        pool.release(resource);
        resource = (Resource)pool.acquire();
        Assert.assertEquals((long)1L, (long)resource.mInteger.intValue());
    }

    @Test
    public void acquireRentlyUsed() throws Exception {
        ManualClock manualClock = new ManualClock();
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions(), manualClock);
        ArrayList<Object> resourceList = new ArrayList<Object>();
        resourceList.add(pool.acquire());
        resourceList.add(pool.acquire());
        resourceList.add(pool.acquire());
        pool.release(resourceList.get(2));
        pool.release(resourceList.get(0));
        manualClock.addTimeMs(1500L);
        pool.release(resourceList.get(1));
        for (int i = 0; i < 10; ++i) {
            Resource resource = (Resource)pool.acquire();
            Assert.assertEquals((long)1L, (long)resource.mInteger.intValue());
            pool.release(resource);
        }
    }

    @Test
    public void gc() throws Exception {
        ManualClock manualClock = new ManualClock();
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions().setGcIntervalMs(10L).setInitialDelayMs(1L), manualClock);
        pool.setGcThresholdInSecs(1);
        ArrayList<Object> resourceList = new ArrayList<Object>();
        resourceList.add(pool.acquire());
        resourceList.add(pool.acquire());
        pool.release(resourceList.get(0));
        manualClock.addTimeMs(1001L);
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)((Resource)pool.acquire()).mInteger.intValue());
    }

    @Test
    public void multiClients() throws Exception {
        TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(1));
        Resource resource1 = (Resource)pool.acquire();
        Assert.assertEquals((long)0L, (long)resource1.mInteger.intValue());
        class ReleaseThread
        extends Thread {
            private TestPool mPool;
            private Resource mResource;

            ReleaseThread(TestPool pool, Resource resource) {
                this.mPool = pool;
                this.mResource = resource;
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                this.mPool.release(this.mResource);
            }
        }
        ReleaseThread releaseThread = new ReleaseThread(pool, resource1);
        releaseThread.start();
        Resource resource2 = (Resource)pool.acquire(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)resource2.mInteger.intValue());
    }

    @Test
    public void TimestampOverflow() {
        Callable<Resource> task = () -> {
            TestPool pool = new TestPool(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(1));
            pool.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            return (Resource)pool.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        };
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Resource> future = executor.submit(task);
        boolean timeout = false;
        try {
            future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)future.isDone());
        future.cancel(true);
    }

    private static final class TestPool
    extends DynamicResourcePool<Resource> {
        private int mGcThresholdInSecs = 120;
        private int mCounter = 0;
        private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(5, ThreadFactoryUtils.build((String)"TestPool-%d", (boolean)true));

        public TestPool(DynamicResourcePool.Options options, ManualClock clock) {
            super(options.setGcExecutor(GC_EXECUTOR));
            this.mClock = clock;
        }

        public TestPool(DynamicResourcePool.Options options) {
            super(options.setGcExecutor(GC_EXECUTOR));
        }

        protected boolean shouldGc(DynamicResourcePool.ResourceInternal<Resource> resourceInternal) {
            return this.mClock.millis() - resourceInternal.getLastAccessTimeMs() >= (long)this.mGcThresholdInSecs * 1000L;
        }

        protected boolean isHealthy(Resource resource) {
            return resource.mInteger < 10;
        }

        protected void closeResource(Resource resource) {
            resource.setInteger(10);
        }

        protected Resource createNewResource() {
            return new Resource(this.mCounter++);
        }

        public void setGcThresholdInSecs(int gcThresholdInSecs) {
            this.mGcThresholdInSecs = gcThresholdInSecs;
        }
    }

    private static final class Resource {
        private Integer mInteger = 0;
        private static final int INVALID_RESOURCE = 10;

        public Resource(Integer i) {
            this.mInteger = i;
        }

        public Resource setInteger(Integer i) {
            this.mInteger = i;
            return this;
        }
    }
}

