/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.CloseableIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class CloseableIteratorTest {
    @Test
    public void concatTwo() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1, 2});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{3, 4, 5});
        TestIterator iterator1 = new TestIterator(list1);
        TestIterator iterator2 = new TestIterator(list2);
        CloseableIterator iterator3 = CloseableIterator.concat((CloseableIterator)iterator1, (CloseableIterator)iterator2);
        Iterators.elementsEqual((Iterator)Iterators.concat(list1.iterator(), list2.iterator()), (Iterator)((Iterator)iterator3.get()));
        iterator3.close();
        Assert.assertTrue((boolean)iterator1.isClosed());
        Assert.assertTrue((boolean)iterator2.isClosed());
    }

    @Test
    public void concatList() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1, 2});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{3, 4, 5});
        ArrayList list3 = Lists.newArrayList((Object[])new Integer[]{0});
        TestIterator iterator1 = new TestIterator(list1);
        TestIterator iterator2 = new TestIterator(list2);
        TestIterator iterator3 = new TestIterator(list3);
        CloseableIterator iterator4 = CloseableIterator.concat((List)Lists.newArrayList((Object[])new CloseableIterator[]{iterator1, iterator2, iterator3}));
        Iterators.elementsEqual((Iterator)Iterators.concat(list1.iterator(), list2.iterator(), list3.iterator()), (Iterator)((Iterator)iterator4.get()));
        iterator4.close();
        Assert.assertTrue((boolean)iterator1.isClosed());
        Assert.assertTrue((boolean)iterator2.isClosed());
        Assert.assertTrue((boolean)iterator3.isClosed());
    }

    @Test
    public void noopCloseable() {
        Iterator iterator = Lists.newArrayList((Object[])new Integer[]{1, 2}).iterator();
        CloseableIterator closeable = CloseableIterator.noopCloseable(Lists.newArrayList((Object[])new Integer[]{1, 2}).iterator());
        Iterators.elementsEqual(iterator, (Iterator)((Iterator)closeable.get()));
    }

    static class TestIterator
    extends CloseableIterator<Integer> {
        private boolean mClosed;

        public TestIterator(List<Integer> list) {
            super(list.iterator());
        }

        public void close() {
            this.mClosed = true;
        }

        public boolean isClosed() {
            return this.mClosed;
        }
    }
}

