/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network;

import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.network.TieredIdentityFactory;
import alluxio.test.util.CommonUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.TieredIdentity;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class TieredIdentityFactoryTest {
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void defaultConf() throws Exception {
        TieredIdentity identity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
        TieredIdentity expected = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", NetworkAddressUtils.getLocalNodeName((AlluxioConfiguration)this.mConfiguration)), new TieredIdentity.LocalityTier("rack", null)));
        Assert.assertEquals((Object)expected, (Object)identity);
    }

    @Test
    public void fromScript() throws Exception {
        String scriptPath = this.setupScript("node=myhost,rack=myrack,custom=mycustom", this.mFolder.newFile());
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.LOCALITY_ORDER, (Object)"node,rack,custom", (Object)PropertyKey.LOCALITY_SCRIPT, (Object)scriptPath), this.mConfiguration).toResource();){
            TieredIdentity identity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            TieredIdentity expected = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", "myhost"), new TieredIdentity.LocalityTier("rack", "myrack"), new TieredIdentity.LocalityTier("custom", "mycustom")));
            Assert.assertEquals((Object)expected, (Object)identity);
        }
    }

    @Test
    public void fromScriptClasspath() throws Exception {
        String customScriptName = "my-alluxio-locality.sh";
        File dir = this.mFolder.newFolder("fromScriptClasspath");
        CommonUtils.classLoadURL(dir.getCanonicalPath());
        File script = new File(dir, customScriptName);
        this.setupScript("node=myhost,rack=myrack,custom=mycustom", script);
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.LOCALITY_ORDER, (Object)"node,rack,custom", (Object)PropertyKey.LOCALITY_SCRIPT, (Object)customScriptName), this.mConfiguration).toResource();){
            TieredIdentity identity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            TieredIdentity expected = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", "myhost"), new TieredIdentity.LocalityTier("rack", "myrack"), new TieredIdentity.LocalityTier("custom", "mycustom")));
            Assert.assertEquals((Object)expected, (Object)identity);
        }
        script.delete();
    }

    @Test
    public void overrideScript() throws Exception {
        String scriptPath = this.setupScript("node=myhost,rack=myrack,custom=mycustom", this.mFolder.newFile());
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.Template.LOCALITY_TIER.format(new Object[]{"node"}), (Object)"overridden", (Object)PropertyKey.LOCALITY_ORDER, (Object)"node,rack,custom", (Object)PropertyKey.LOCALITY_SCRIPT, (Object)scriptPath), this.mConfiguration).toResource();){
            TieredIdentity identity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            TieredIdentity expected = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", "overridden"), new TieredIdentity.LocalityTier("rack", "myrack"), new TieredIdentity.LocalityTier("custom", "mycustom")));
            Assert.assertEquals((Object)expected, (Object)identity);
        }
    }

    @Test
    public void outOfOrderScript() throws Exception {
        String scriptPath = this.setupScript("rack=myrack,node=myhost", this.mFolder.newFile());
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.LOCALITY_SCRIPT, (Object)scriptPath), this.mConfiguration).toResource();){
            TieredIdentity identity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            TieredIdentity expected = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", "myhost"), new TieredIdentity.LocalityTier("rack", "myrack")));
            Assert.assertEquals((Object)expected, (Object)identity);
        }
    }

    @Test
    public void repeatedScriptKey() throws Exception {
        String output = "rack=myrack,node=myhost,rack=myrack2";
        this.mThrown.expectMessage("Encountered repeated tier definition for rack when parsing tiered identity from string rack=myrack,node=myhost,rack=myrack2");
        this.runScriptWithOutput(output);
    }

    @Test
    public void unknownScriptKey() throws Exception {
        String badOutput = "unknown=x";
        this.mThrown.expectMessage("Unrecognized tier: unknown. The tiers defined by alluxio.locality.order are [node, rack]");
        this.runScriptWithOutput(badOutput);
    }

    @Test
    public void invalidScriptOutput() throws Exception {
        for (String badOutput : new String[]{"x", "a=b c=d", "node=b,cd", "node=b,abc,x=y"}) {
            try {
                this.runScriptWithOutput(badOutput);
                Assert.fail((String)"Expected an exception to be thrown");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to parse"));
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)badOutput));
            }
        }
    }

    @Test
    public void notExecutable() throws Exception {
        File script = this.mFolder.newFile();
        FileUtils.writeStringToFile((File)script, (String)"#!/bin/bash");
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.LOCALITY_SCRIPT, (Object)script.getAbsolutePath()), this.mConfiguration).toResource();){
            try {
                TieredIdentity tieredIdentity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            }
            catch (RuntimeException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)script.getAbsolutePath()));
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Permission denied"));
            }
        }
    }

    @Test
    public void fromString() throws Exception {
        Assert.assertEquals((Object)new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", "b"), new TieredIdentity.LocalityTier("rack", "d"))), (Object)TieredIdentityFactory.fromString((String)"node=b,rack=d", (AlluxioConfiguration)this.mConfiguration));
    }

    private String setupScript(String tieredIdentityString, File script) throws Exception {
        String content = "#!/bin/bash\necho \"" + tieredIdentityString + "\"\n";
        FileUtils.writeStringToFile((File)script, (String)content);
        script.setExecutable(true);
        return script.getAbsolutePath();
    }

    private TieredIdentity runScriptWithOutput(String output) throws Exception {
        String scriptPath = this.setupScript(output, this.mFolder.newFile());
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.LOCALITY_SCRIPT, (Object)scriptPath), this.mConfiguration).toResource();){
            TieredIdentity tieredIdentity = TieredIdentityFactory.create((AlluxioConfiguration)this.mConfiguration);
            return tieredIdentity;
        }
    }
}

