/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.grpc.Metric;
import alluxio.grpc.MetricType;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import com.codahale.metrics.Counter;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class MetricsSystemTest {
    @Before
    public final void before() {
        MetricsSystem.resetAllMetrics();
    }

    @Test
    public void multipleSinksTest() {
        Properties metricsProps = new Properties();
        metricsProps.setProperty("sink.console.class", "alluxio.metrics.sink.ConsoleSink");
        metricsProps.setProperty("sink.console.period", "20");
        metricsProps.setProperty("sink.console.period", "20");
        metricsProps.setProperty("sink.console.unit", "minutes");
        metricsProps.setProperty("sink.jmx.class", "alluxio.metrics.sink.JmxSink");
        MetricsConfig metricsConfig = new MetricsConfig(metricsProps);
        MetricsSystem.startSinksFromConfig((MetricsConfig)metricsConfig);
        Assert.assertEquals((long)2L, (long)MetricsSystem.getNumSinks());
        MetricsSystem.stopSinks();
    }

    @Test
    public void startStopSinkTest() throws Exception {
        File workerDirectory = AlluxioTestDirectory.createTemporaryDirectory("sinks");
        Properties properties = new Properties();
        properties.put("sink.csv.class", "alluxio.metrics.sink.CsvSink");
        properties.put("sink.csv.period", "1");
        properties.put("sink.csv.unit", "seconds");
        properties.put("sink.csv.directory", workerDirectory.getAbsolutePath());
        MetricsConfig config = new MetricsConfig(properties);
        MetricsSystem.startSinksFromConfig((MetricsConfig)config);
        String counterName = "Master.CounterForSinkTest";
        MetricsSystem.counter((String)counterName).inc(100L);
        Thread.sleep(2000L);
        String[] pathNames = workerDirectory.list();
        Assert.assertNotNull((Object)pathNames);
        HashSet<String> filesSet = new HashSet<String>(Arrays.asList(pathNames));
        Assert.assertNotEquals((long)0L, (long)filesSet.size());
        Assert.assertTrue((boolean)filesSet.contains(counterName + ".csv"));
        MetricsSystem.stopSinks();
        String meterName = "Master.MeterForSinkTest";
        MetricsSystem.meter((String)meterName).mark(1000L);
        pathNames = workerDirectory.list();
        Assert.assertNotNull((Object)pathNames);
        filesSet = new HashSet<String>(Arrays.asList(pathNames));
        Assert.assertTrue((!filesSet.contains(meterName + ".csv") ? 1 : 0) != 0);
    }

    @Test
    public void testEscape() {
        AlluxioURI localUri1 = new AlluxioURI("/foo/alluxio/underFSStorage");
        String localUriEscaped1 = MetricsSystem.escape((AlluxioURI)localUri1);
        Assert.assertEquals((Object)"%2Ffoo%2Falluxio%2FunderFSStorage", (Object)localUriEscaped1);
        AlluxioURI localUri2 = new AlluxioURI("/.alluxio.wololo/alluxio/underFSStorage");
        String localUriEscaped2 = MetricsSystem.escape((AlluxioURI)localUri2);
        Assert.assertEquals((Object)"%2F%2Ealluxio%2Ewololo%2Falluxio%2FunderFSStorage", (Object)localUriEscaped2);
        AlluxioURI localUri3 = new AlluxioURI("/%25alluxio%20user%2Ffoo%2Ebar/alluxio/underFSStorage");
        String localUriEscaped3 = MetricsSystem.escape((AlluxioURI)localUri3);
        Assert.assertEquals((Object)"%2F%2525alluxio%2520user%252Ffoo%252Ebar%2Falluxio%2FunderFSStorage", (Object)localUriEscaped3);
        AlluxioURI localUri4 = new AlluxioURI("s3a://test/Tasks+Export+%282017\u201311\u201305+06%3A10+PM%2Ecsv");
        String localUriEscaped4 = MetricsSystem.escape((AlluxioURI)localUri4);
        Assert.assertEquals((Object)"s3a:%2F%2Ftest%2FTasks+Export+%25282017\u201311\u201305+06%253A10+PM%252Ecsv", (Object)localUriEscaped4);
    }

    @Test
    public void testUnescape() {
        AlluxioURI localUri1 = new AlluxioURI("/foo/alluxio/underFSStorage");
        String localUriEscaped1 = MetricsSystem.escape((AlluxioURI)localUri1);
        String localUriUnescaped1 = MetricsSystem.unescape((String)localUriEscaped1);
        Assert.assertEquals((Object)localUri1.toString(), (Object)localUriUnescaped1);
        AlluxioURI localUri2 = new AlluxioURI("/.alluxio.wololo/alluxio/underFSStorage");
        String localUriEscaped2 = MetricsSystem.escape((AlluxioURI)localUri2);
        String localUriUnescaped2 = MetricsSystem.unescape((String)localUriEscaped2);
        Assert.assertEquals((Object)localUri2.toString(), (Object)localUriUnescaped2);
        AlluxioURI localUri3 = new AlluxioURI("/%25alluxio%20user%2Ffoo%2Ebar/alluxio/underFSStorage");
        String localUriEscaped3 = MetricsSystem.escape((AlluxioURI)localUri3);
        String localUriUnescaped3 = MetricsSystem.unescape((String)localUriEscaped3);
        Assert.assertEquals((Object)localUri3.toString(), (Object)localUriUnescaped3);
        AlluxioURI localUri4 = new AlluxioURI("s3a://test/Tasks+Export+%282017\u201311\u201305+06%3A10+PM%2Ecsv");
        String localUriEscaped4 = MetricsSystem.escape((AlluxioURI)localUri4);
        String localUriUnescaped4 = MetricsSystem.unescape((String)localUriEscaped4);
        Assert.assertEquals((Object)localUri4.toString(), (Object)localUriUnescaped4);
    }

    @Test
    public void testReportWorkerMetrics() {
        String metricName = "Worker.TestMetric";
        Counter counter = MetricsSystem.counter((String)metricName);
        if (!MetricKey.isValid((String)metricName)) {
            MetricKey.register((MetricKey)new MetricKey.Builder(metricName).setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build());
            MetricsSystem.initShouldReportMetrics((MetricsSystem.InstanceType)MetricsSystem.InstanceType.WORKER);
        }
        counter.inc();
        Assert.assertEquals((double)1.0, (double)((Metric)MetricsSystem.reportWorkerMetrics().get(0)).getValue(), (double)0.0);
        Assert.assertEquals((long)0L, (long)MetricsSystem.reportWorkerMetrics().size());
        counter.inc();
        Assert.assertEquals((double)1.0, (double)((Metric)MetricsSystem.reportWorkerMetrics().get(0)).getValue(), (double)0.0);
    }

    @Test
    public void testReportClientMetrics() {
        String metricName = "Client.TestMetric";
        Counter counter = MetricsSystem.counter((String)metricName);
        if (!MetricKey.isValid((String)metricName)) {
            MetricKey.register((MetricKey)new MetricKey.Builder(metricName).setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build());
        }
        counter.inc(5L);
        Assert.assertEquals((double)5.0, (double)((Metric)MetricsSystem.reportClientMetrics().get(0)).getValue(), (double)0.0);
        Assert.assertEquals((long)0L, (long)MetricsSystem.reportClientMetrics().size());
        counter.inc(2L);
        Assert.assertEquals((double)2.0, (double)((Metric)MetricsSystem.reportClientMetrics().get(0)).getValue(), (double)0.0);
        Assert.assertEquals((long)0L, (long)MetricsSystem.reportClientMetrics().size());
    }

    @Test
    public void testResetAllMetrics() {
        String counterName = "Worker.Counter";
        MetricsSystem.counter((String)counterName).inc();
        Assert.assertEquals((long)1L, (long)MetricsSystem.counter((String)counterName).getCount());
        String meterName = "Worker.Meter";
        MetricsSystem.meter((String)meterName).mark(1000L);
        Assert.assertEquals((long)1000L, (long)MetricsSystem.meter((String)meterName).getCount());
        String timerName = "Worker.Timer";
        MetricsSystem.timer((String)timerName).time().close();
        Assert.assertEquals((long)1L, (long)MetricsSystem.timer((String)timerName).getCount());
        MetricsSystem.resetAllMetrics();
        Assert.assertEquals((long)0L, (long)MetricsSystem.counter((String)counterName).getCount());
        Assert.assertEquals((long)0L, (long)MetricsSystem.meter((String)meterName).getCount());
        Assert.assertEquals((long)0L, (long)MetricsSystem.reportWorkerMetrics().size());
        Assert.assertEquals((long)0L, (long)MetricsSystem.timer((String)timerName).getCount());
    }

    @Test
    public void getMetricNameTest() {
        Assert.assertEquals((Object)"Cluster.counter", (Object)MetricsSystem.getMetricName((String)"Cluster.counter"));
        Assert.assertEquals((Object)"Master.timer", (Object)MetricsSystem.getMetricName((String)"Master.timer"));
        String workerGaugeName = "Worker.gauge";
        Assert.assertNotEquals((Object)workerGaugeName, (Object)MetricsSystem.getMetricName((String)workerGaugeName));
        Assert.assertTrue((boolean)MetricsSystem.getMetricName((String)workerGaugeName).startsWith(workerGaugeName));
        String clientCounterName = "Client.counter";
        Assert.assertNotEquals((Object)clientCounterName, (Object)MetricsSystem.getMetricName((String)clientCounterName));
        Assert.assertTrue((boolean)MetricsSystem.getMetricName((String)clientCounterName).startsWith(clientCounterName));
    }

    @Test
    public void stripInstanceAndHostTest() {
        Assert.assertEquals((Object)"name", (Object)MetricsSystem.stripInstanceAndHost((String)"Master.name"));
        Assert.assertEquals((Object)"name", (Object)MetricsSystem.stripInstanceAndHost((String)"Worker.name.10_0_0_136"));
        Assert.assertEquals((Object)"name.UFS:ufs", (Object)MetricsSystem.stripInstanceAndHost((String)"Client.name.UFS:ufs.0_0_0_0"));
        Assert.assertEquals((Object)"name.UFS:ufs.UFS_TYPE:local", (Object)MetricsSystem.stripInstanceAndHost((String)"Worker.name.UFS:ufs.UFS_TYPE:local.0_0_0_0"));
    }
}

