/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.metrics.MetricsConfig;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class MetricsConfigTest {
    private Properties mMetricsProps;

    @Before
    public final void before() {
        this.mMetricsProps = new Properties();
        this.mMetricsProps.setProperty("sink.console.class", "alluxio.metrics.sink.ConsoleSink");
        this.mMetricsProps.setProperty("sink.console.period", "15");
        this.mMetricsProps.setProperty("*.sink.console.unit", "minutes");
        this.mMetricsProps.setProperty("sink.jmx.class", "alluxio.metrics.sink.JmxSink");
    }

    @Test
    public void setProperties() {
        MetricsConfig config = new MetricsConfig(this.mMetricsProps);
        Properties masterProp = config.getProperties();
        Assert.assertEquals((long)4L, (long)masterProp.size());
        Assert.assertEquals((Object)"alluxio.metrics.sink.ConsoleSink", (Object)masterProp.getProperty("sink.console.class"));
        Assert.assertEquals((Object)"15", (Object)masterProp.getProperty("sink.console.period"));
        Assert.assertEquals((Object)"minutes", (Object)masterProp.getProperty("sink.console.unit"));
        Assert.assertEquals((Object)"alluxio.metrics.sink.JmxSink", (Object)masterProp.getProperty("sink.jmx.class"));
    }

    @Test
    public void subProperties() {
        MetricsConfig config = new MetricsConfig(this.mMetricsProps);
        Properties properties = config.getProperties();
        Map sinkProps = MetricsConfig.subProperties((Properties)properties, (String)"^sink\\.(.+)\\.(.+)");
        Assert.assertEquals((long)2L, (long)sinkProps.size());
        Assert.assertTrue((boolean)sinkProps.containsKey("console"));
        Assert.assertTrue((boolean)sinkProps.containsKey("jmx"));
        Properties consoleProp = (Properties)sinkProps.get("console");
        Assert.assertEquals((long)3L, (long)consoleProp.size());
        Assert.assertEquals((Object)"alluxio.metrics.sink.ConsoleSink", (Object)consoleProp.getProperty("class"));
        Properties jmxProp = (Properties)sinkProps.get("jmx");
        Assert.assertEquals((long)1L, (long)jmxProp.size());
        Assert.assertEquals((Object)"alluxio.metrics.sink.JmxSink", (Object)jmxProp.getProperty("class"));
    }
}

