/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.grpc.MetricType;
import alluxio.metrics.Metric;
import alluxio.metrics.MetricsSystem;
import alluxio.util.CommonUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class MetricTest {
    @Test
    public void proto() {
        Metric metric = MetricTest.createRandom();
        Metric other = Metric.fromProto((alluxio.grpc.Metric)metric.toProto());
        this.checkEquality(metric, other);
    }

    @Test
    public void testFullNameParsing() {
        String fullName = "Client.metric.tag1:A::/.tag2:B:/.192_1_1_1|A";
        Metric metric = Metric.from((String)fullName, (double)1.0, (MetricType)MetricType.COUNTER);
        Assert.assertEquals((Object)fullName, (Object)metric.getFullMetricName());
    }

    @Test
    public void testMetricNameWithTags() {
        Assert.assertEquals((Object)"metric.t1:v1.t2:v2:", (Object)Metric.getMetricNameWithTags((String)"metric", (String[])new String[]{"t1", "v1", "t2", "v2:"}));
    }

    public void checkEquality(Metric a, Metric b) {
        Assert.assertEquals((Object)a.getName(), (Object)b.getName());
        Assert.assertEquals((Object)a.getInstanceType(), (Object)b.getInstanceType());
        Assert.assertEquals((double)a.getValue(), (double)b.getValue(), (double)1.0E-15);
        Assert.assertEquals((Object)a.getSource(), (Object)b.getSource());
        Assert.assertEquals((Object)a.getFullMetricName(), (Object)b.getFullMetricName());
    }

    public static Metric createRandom() {
        Random random = new Random();
        int idx = random.nextInt(MetricsSystem.InstanceType.values().length);
        MetricsSystem.InstanceType instance = MetricsSystem.InstanceType.values()[idx];
        String hostname = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String name = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        double value = random.nextLong();
        MetricType metricType = MetricType.forNumber((int)random.nextInt(MetricType.values().length));
        return new Metric(instance, hostname, metricType, name, Double.valueOf(value));
    }
}

