/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block;

import alluxio.master.block.BlockId;
import org.junit.Assert;
import org.junit.Test;

public final class BlockIdTest {
    private static final long MAX_SEQUENCE_NUMBER = 0xFFFFFFL;

    @Test
    public void createBlockIdWithMaxSequenceNumber() {
        Assert.assertEquals((long)0x1FFFFFFL, (long)BlockId.createBlockId((long)1L, (long)BlockId.getMaxSequenceNumber()));
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.createBlockId((long)0L, (long)BlockId.getMaxSequenceNumber()));
        Assert.assertEquals((long)0xFFFFFFFFL, (long)BlockId.createBlockId((long)255L, (long)BlockId.getMaxSequenceNumber()));
    }

    @Test
    public void createBlockId() {
        Assert.assertEquals((long)16797216L, (long)BlockId.createBlockId((long)1L, (long)20000L));
        Assert.assertEquals((long)20000L, (long)BlockId.createBlockId((long)0L, (long)20000L));
        Assert.assertEquals((long)2071248101952L, (long)BlockId.createBlockId((long)123456L, (long)123456L));
    }

    @Test
    public void getContainerIdAndSequenceNumber() {
        Assert.assertEquals((long)1L, (long)BlockId.getContainerId((long)0x1FFFFFFL));
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.getSequenceNumber((long)0x1FFFFFFL));
        Assert.assertEquals((long)255L, (long)BlockId.getContainerId((long)0xFFFFFFFFL));
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.getSequenceNumber((long)0xFFFFFFFFL));
        Assert.assertEquals((long)123456L, (long)BlockId.getContainerId((long)2071248101952L));
        Assert.assertEquals((long)123456L, (long)BlockId.getSequenceNumber((long)2071248101952L));
    }

    @Test
    public void getFileId() {
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.getFileId((long)1L));
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.getFileId((long)20000L));
        Assert.assertEquals((long)0x1FFFFFFL, (long)BlockId.getFileId((long)0x1FFFFFEL));
        Assert.assertEquals((long)2071264755711L, (long)BlockId.getFileId((long)2071248101952L));
    }

    @Test
    public void getMaxSequenceNumber() {
        Assert.assertEquals((long)0xFFFFFFL, (long)BlockId.getMaxSequenceNumber());
    }
}

