/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.exception.status.UnavailableException;
import alluxio.master.ZkMasterInquireClient;
import alluxio.util.io.PathUtils;
import java.net.InetSocketAddress;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZkMasterInquireClientTest {
    private static final String ELECTION_PATH = "/election";
    private static final String LEADER_PATH = "/leader";
    private static final String LOOPBACK_IP = "127.0.0.1";
    private static final int TESTING_SERVER_PORT = 11111;
    private static final int INQUIRE_RETRY_COUNT = 2;
    private static final boolean ZOOKEEPER_AUTH_ENABLED = true;
    private TestingServer mZkServer;

    @Before
    public void before() throws Exception {
        this.mZkServer = new TestingServer(11111, AlluxioTestDirectory.createTemporaryDirectory("zk"));
    }

    @After
    public void after() throws Exception {
        if (this.mZkServer != null) {
            this.mZkServer.close();
        }
    }

    @Test
    public void testNoParticipant() throws Exception {
        ZkMasterInquireClient zkInquirer = ZkMasterInquireClient.getClient((String)this.mZkServer.getConnectString(), (String)ELECTION_PATH, (String)LEADER_PATH, (int)2, (boolean)true);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.mZkServer.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 2));
        client.start();
        client.create().forPath(LEADER_PATH);
        client.close();
        boolean queryFailed = false;
        try {
            zkInquirer.getPrimaryRpcAddress();
        }
        catch (UnavailableException e) {
            queryFailed = true;
        }
        Assert.assertTrue((String)"Master query should have been failed.", (boolean)queryFailed);
    }

    @Test
    public void testNoPath() throws Exception {
        ZkMasterInquireClient zkInquirer = ZkMasterInquireClient.getClient((String)this.mZkServer.getConnectString(), (String)ELECTION_PATH, (String)LEADER_PATH, (int)2, (boolean)true);
        boolean queryFailed = false;
        try {
            zkInquirer.getPrimaryRpcAddress();
        }
        catch (UnavailableException e) {
            queryFailed = true;
        }
        Assert.assertTrue((String)"Master query should have been failed.", (boolean)queryFailed);
    }

    @Test
    public void testSingleLeader() throws Exception {
        ZkMasterInquireClient zkInquirer = ZkMasterInquireClient.getClient((String)this.mZkServer.getConnectString(), (String)ELECTION_PATH, (String)LEADER_PATH, (int)2, (boolean)true);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.mZkServer.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 2));
        InetSocketAddress localLeader = InetSocketAddress.createUnresolved(LOOPBACK_IP, 12345);
        client.start();
        client.create().forPath(LEADER_PATH);
        client.create().forPath(PathUtils.concatPath((Object)LEADER_PATH, (Object)localLeader));
        client.close();
        Assert.assertEquals((Object)localLeader, (Object)zkInquirer.getPrimaryRpcAddress());
    }

    @Test
    public void testMultipleLeaders() throws Exception {
        ZkMasterInquireClient zkInquirer = ZkMasterInquireClient.getClient((String)this.mZkServer.getConnectString(), (String)ELECTION_PATH, (String)LEADER_PATH, (int)2, (boolean)true);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.mZkServer.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 2));
        InetSocketAddress localLeader1 = InetSocketAddress.createUnresolved(LOOPBACK_IP, 12345);
        InetSocketAddress localLeader2 = InetSocketAddress.createUnresolved(LOOPBACK_IP, 54321);
        client.start();
        client.create().forPath(LEADER_PATH);
        client.create().forPath(PathUtils.concatPath((Object)LEADER_PATH, (Object)localLeader1));
        client.create().forPath(PathUtils.concatPath((Object)LEADER_PATH, (Object)localLeader2));
        client.close();
        Assert.assertEquals((Object)localLeader2, (Object)zkInquirer.getPrimaryRpcAddress());
    }
}

