/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.PortRegistry;
import alluxio.master.PortReservationRule;
import java.io.Closeable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PortReservationRuleTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @After
    public void after() {
        PortRegistry.clear();
    }

    @Test
    public void basic() throws Exception {
        PortReservationRule rule = new PortReservationRule();
        for (int attempt = 0; attempt < 20; ++attempt) {
            int port;
            try (Closeable c = rule.toResource();){
                port = rule.getPort();
                Assert.assertFalse((String)"Port should be locked, so we cannot re-lock", (boolean)PortRegistry.INSTANCE.lockPort(port));
            }
            if (!PortRegistry.INSTANCE.lockPort(port)) continue;
            return;
        }
        Assert.fail((String)"Failed to lock port after closing the port rule");
    }

    @Test
    public void invalidGetPort() {
        PortReservationRule rule = new PortReservationRule();
        this.mThrown.expect(IllegalStateException.class);
        rule.getPort();
    }
}

