/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PortRegistry {
    private static final String PORT_COORDINATION_DIR_PROPERTY = "ALLUXIO_PORT_COORDINATION_DIR";
    @VisibleForTesting
    static final Registry INSTANCE = new Registry();

    private PortRegistry() {
    }

    public static int reservePort() {
        return INSTANCE.reservePort();
    }

    public static void release(int port) {
        INSTANCE.release(port);
    }

    public static void clear() {
        INSTANCE.clear();
    }

    public static int getFreePort() {
        int port;
        try {
            ServerSocket socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return port;
    }

    @VisibleForTesting
    static class Registry {
        private final Map<Integer, Reservation> mReserved = new ConcurrentHashMap<Integer, Reservation>();
        private final File mCoordinationDir;

        public Registry() {
            String dir = System.getenv(PortRegistry.PORT_COORDINATION_DIR_PROPERTY);
            if (dir == null) {
                dir = System.getProperty("user.dir");
            }
            this.mCoordinationDir = new File(dir, ".port_coordination");
            this.mCoordinationDir.mkdirs();
        }

        public int reservePort() {
            for (int i = 0; i < 1000; ++i) {
                int port = PortRegistry.getFreePort();
                if (!this.lockPort(port)) continue;
                return port;
            }
            throw new RuntimeException("Failed to acquire port");
        }

        public boolean lockPort(int port) {
            File portFile = this.portFile(port);
            try {
                FileChannel channel = new RandomAccessFile(portFile, "rw").getChannel();
                FileLock lock = channel.tryLock();
                if (lock == null) {
                    channel.close();
                    return false;
                }
                this.mReserved.put(port, new Reservation(portFile, lock));
                return true;
            }
            catch (IOException | OverlappingFileLockException e) {
                return false;
            }
        }

        public void release(int port) {
            Reservation r = this.mReserved.remove(port);
            if (r != null) {
                r.mFile.delete();
                try {
                    r.mLock.release();
                    r.mLock.channel().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void clear() {
            new HashSet<Integer>(this.mReserved.keySet()).forEach(this::release);
        }

        public File portFile(int port) {
            return new File(this.mCoordinationDir, Integer.toString(port));
        }

        private static class Reservation {
            private final File mFile;
            private final FileLock mLock;

            private Reservation(File file, FileLock lock) {
                this.mFile = file;
                this.mLock = lock;
            }
        }
    }
}

