/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ConfigurationBuilder;
import alluxio.exception.status.UnavailableException;
import alluxio.master.PollingMasterInquireClient;
import alluxio.master.PortReservationRule;
import alluxio.network.RejectingServer;
import alluxio.retry.CountingRetry;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PollingMasterInquireClientTest {
    @Rule
    public PortReservationRule mPort = new PortReservationRule();

    @Test(timeout=10000L)
    public void pollRejectingDoesntHang() throws Exception {
        int port = this.mPort.getPort();
        InetSocketAddress serverAddress = new InetSocketAddress("127.0.0.1", port);
        RejectingServer s = new RejectingServer(serverAddress);
        s.start();
        List<InetSocketAddress> addrs = Arrays.asList(InetSocketAddress.createUnresolved(NetworkAddressUtils.getLocalHostName((int)1000), port));
        PollingMasterInquireClient client = new PollingMasterInquireClient(addrs, () -> new CountingRetry(0), (AlluxioConfiguration)new ConfigurationBuilder().build());
        try {
            client.getPrimaryRpcAddress();
            Assert.fail((String)"Expected polling to fail");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
    }
}

