/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.ConfigurationRule;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterInquireClient;
import alluxio.master.SingleMasterInquireClient;
import alluxio.master.ZkMasterInquireClient;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class MasterInquireClientTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    @Test
    public void defaultConnectString() {
        SingleMasterInquireClient.SingleMasterConnectDetails cs = new SingleMasterInquireClient.SingleMasterConnectDetails(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)this.mConfiguration));
        this.assertCurrentConnectString((MasterInquireClient.ConnectDetails)cs);
        Assert.assertEquals((Object)(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)this.mConfiguration) + ":" + NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)this.mConfiguration)), (Object)cs.toString());
    }

    @Test
    public void singleMasterConnectString() throws Exception {
        final String host = "testhost";
        final int port = 123;
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)new HashMap<PropertyKey, String>(){
            {
                this.put(PropertyKey.MASTER_HOSTNAME, host);
                this.put(PropertyKey.MASTER_RPC_PORT, Integer.toString(port));
            }
        }, this.mConfiguration).toResource();){
            SingleMasterInquireClient.SingleMasterConnectDetails cs = new SingleMasterInquireClient.SingleMasterConnectDetails(InetSocketAddress.createUnresolved(host, port));
            this.assertCurrentConnectString((MasterInquireClient.ConnectDetails)cs);
            Assert.assertEquals((Object)"testhost:123", (Object)cs.toString());
        }
    }

    @Test
    public void zkConnectString() throws Exception {
        final String zkAddr = "zkAddr:1234";
        final String leaderPath = "/my/leader/path";
        try (Closeable c = new ConfigurationRule((Map<PropertyKey, String>)new HashMap<PropertyKey, String>(){
            {
                this.put(PropertyKey.MASTER_JOURNAL_TYPE, "UFS");
                this.put(PropertyKey.ZOOKEEPER_ADDRESS, zkAddr);
                this.put(PropertyKey.ZOOKEEPER_LEADER_PATH, leaderPath);
            }
        }, this.mConfiguration).toResource();){
            SingleMasterInquireClient.SingleMasterConnectDetails singleConnect = new SingleMasterInquireClient.SingleMasterConnectDetails(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)this.mConfiguration));
            this.assertCurrentConnectString((MasterInquireClient.ConnectDetails)singleConnect);
            try (Closeable c2 = new ConfigurationRule(PropertyKey.ZOOKEEPER_ENABLED, "true", this.mConfiguration).toResource();){
                ZkMasterInquireClient.ZkMasterConnectDetails zkConnect = new ZkMasterInquireClient.ZkMasterConnectDetails(zkAddr, leaderPath);
                this.assertCurrentConnectString((MasterInquireClient.ConnectDetails)zkConnect);
                Assert.assertEquals((Object)"zk@zkAddr:1234/my/leader/path", (Object)zkConnect.toString());
            }
        }
    }

    private void assertCurrentConnectString(MasterInquireClient.ConnectDetails cs) {
        Assert.assertEquals((Object)cs, (Object)MasterInquireClient.Factory.getConnectDetails((AlluxioConfiguration)this.mConfiguration));
    }
}

