/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.clock.ManualClock;
import alluxio.heartbeat.SleepingTimer;
import alluxio.time.Sleeper;
import java.time.Clock;
import java.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public final class SleepingTimerTest {
    private static final String THREAD_NAME = "sleepingtimer-test-thread-name";
    private static final long INTERVAL_MS = 500L;
    private Logger mMockLogger;
    private ManualClock mFakeClock;
    private Sleeper mMockSleeper;

    @Before
    public void before() {
        this.mMockLogger = (Logger)Mockito.mock(Logger.class);
        this.mFakeClock = new ManualClock();
        this.mMockSleeper = (Sleeper)Mockito.mock(Sleeper.class);
    }

    @Test
    public void warnWhenExecutionTakesLongerThanInterval() throws Exception {
        SleepingTimer timer = new SleepingTimer(THREAD_NAME, 500L, this.mMockLogger, (Clock)this.mFakeClock, this.mMockSleeper);
        timer.tick();
        this.mFakeClock.addTimeMs(2500L);
        timer.tick();
        ((Logger)Mockito.verify((Object)this.mMockLogger)).warn(Matchers.anyString(), new Object[]{Matchers.anyString(), Mockito.anyLong(), Mockito.anyLong()});
    }

    @Test
    public void sleepForSpecifiedInterval() throws Exception {
        SleepingTimer timer = new SleepingTimer(THREAD_NAME, 500L, this.mMockLogger, (Clock)this.mFakeClock, this.mMockSleeper);
        timer.tick();
        ((Sleeper)Mockito.verify((Object)this.mMockSleeper, (VerificationMode)Mockito.times((int)0))).sleep((Duration)Matchers.any(Duration.class));
        timer.tick();
        ((Sleeper)Mockito.verify((Object)this.mMockSleeper)).sleep(Duration.ofMillis(500L));
    }

    @Test
    public void maintainInterval() throws Exception {
        SleepingTimer stimer = new SleepingTimer(THREAD_NAME, 500L, this.mMockLogger, (Clock)this.mFakeClock, this.mMockSleeper);
        stimer.tick();
        this.mFakeClock.addTimeMs(166L);
        stimer.tick();
        ((Sleeper)Mockito.verify((Object)this.mMockSleeper)).sleep(Duration.ofMillis(334L));
    }
}

