/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.HeartbeatTimer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.powermock.reflect.Whitebox;

public final class ManuallyScheduleHeartbeat
implements TestRule {
    private final List<String> mThreads;

    public ManuallyScheduleHeartbeat(List<String> threads) {
        this.mThreads = threads;
    }

    public ManuallyScheduleHeartbeat(String ... threads) {
        this(Arrays.asList(threads));
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (Resource resource = new Resource(ManuallyScheduleHeartbeat.this.mThreads);){
                    statement.evaluate();
                }
            }
        };
    }

    public static class Resource
    implements AutoCloseable {
        private final List<String> mThreads;
        private final Map<String, Class<? extends HeartbeatTimer>> mPrevious;

        public Resource(List<String> threads) {
            this.mThreads = threads;
            this.mPrevious = new HashMap<String, Class<? extends HeartbeatTimer>>();
            for (String threadName : this.mThreads) {
                try {
                    this.mPrevious.put(threadName, HeartbeatContext.getTimerClass((String)threadName));
                    Whitebox.invokeMethod(HeartbeatContext.class, (String)"setTimerClass", (Object[])new Object[]{threadName, HeartbeatContext.SCHEDULED_TIMER_CLASS});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void close() throws Exception {
            for (String threadName : this.mThreads) {
                Whitebox.invokeMethod(HeartbeatContext.class, (String)"setTimerClass", (Object[])new Object[]{threadName, this.mPrevious.get(threadName)});
            }
        }
    }
}

