/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.security.user.UserState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class HeartbeatThreadTest {
    private static final String THREAD_NAME = "heartbeat-thread-test-thread-name";
    private static final int NUMBER_OF_THREADS = 10;
    private ExecutorService mExecutorService;
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();

    @Before
    public void before() {
        this.mExecutorService = Executors.newFixedThreadPool(10);
    }

    @After
    public void after() {
        this.mExecutorService.shutdownNow();
    }

    @Test
    public void serialHeartbeatThread() throws Exception {
        FutureTask<Void> task = new FutureTask<Void>(new DummyHeartbeatTestCallable());
        Thread thread = new Thread(task);
        thread.start();
        thread.join();
        task.get();
    }

    @Test
    public void concurrentHeartbeatThread() throws Exception {
        ArrayList<FutureTask> tasks = new ArrayList<FutureTask>();
        for (int i = 0; i < 10; ++i) {
            FutureTask task = new FutureTask(new DummyHeartbeatTestCallable(i));
            Thread thread = new Thread(task);
            thread.start();
            tasks.add(task);
        }
        for (FutureTask task : tasks) {
            task.get();
        }
    }

    private class DummyHeartbeatExecutor
    implements HeartbeatExecutor {
        private int mCounter = 0;

        private DummyHeartbeatExecutor() {
        }

        public void heartbeat() {
            ++this.mCounter;
        }

        public void close() {
        }

        public int getCounter() {
            return this.mCounter;
        }
    }

    private class DummyHeartbeatTestCallable
    implements Callable<Void> {
        private final String mThreadName;

        public DummyHeartbeatTestCallable() {
            this.mThreadName = HeartbeatThreadTest.THREAD_NAME;
        }

        public DummyHeartbeatTestCallable(int id) {
            this.mThreadName = "heartbeat-thread-test-thread-name-" + id;
        }

        @Override
        @Nullable
        public Void call() throws Exception {
            try (ManuallyScheduleHeartbeat.Resource r = new ManuallyScheduleHeartbeat.Resource(Arrays.asList(this.mThreadName));){
                DummyHeartbeatExecutor executor = new DummyHeartbeatExecutor();
                HeartbeatThread ht = new HeartbeatThread(this.mThreadName, (HeartbeatExecutor)executor, 1L, (AlluxioConfiguration)HeartbeatThreadTest.this.mConfiguration, UserState.Factory.create((AlluxioConfiguration)HeartbeatThreadTest.this.mConfiguration));
                HeartbeatThreadTest.this.mExecutorService.submit((Runnable)ht);
                int numIterations = 5000;
                for (int i = 0; i < 5000; ++i) {
                    HeartbeatScheduler.execute((String)this.mThreadName);
                }
                Assert.assertEquals((String)"The executor counter is wrong.", (long)5000L, (long)executor.getCounter());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return null;
        }
    }
}

