/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.heartbeat.ScheduledTimer;
import alluxio.heartbeat.SleepingTimer;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class HeartbeatContextTest {
    @Test
    public void allThreadsUseSleepingTimer() {
        for (String threadName : HeartbeatContext.getTimerClasses().keySet()) {
            Class timerClass = HeartbeatContext.getTimerClass((String)threadName);
            Assert.assertTrue((boolean)timerClass.isAssignableFrom(SleepingTimer.class));
        }
    }

    @Test
    public void canTemporarilySwitchToScheduledTimer() throws Exception {
        try (ManuallyScheduleHeartbeat.Resource h = new ManuallyScheduleHeartbeat.Resource((List<String>)ImmutableList.of((Object)"Worker Client"));){
            Assert.assertTrue((boolean)HeartbeatContext.getTimerClass((String)"Worker Client").isAssignableFrom(ScheduledTimer.class));
        }
        Assert.assertTrue((boolean)HeartbeatContext.getTimerClass((String)"Worker Client").isAssignableFrom(SleepingTimer.class));
    }
}

