/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.Chunk;
import alluxio.grpc.WriteRequest;
import alluxio.grpc.WriteRequestMarshaller;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class WriteRequestMarshallerTest {
    @Test
    public void close() {
        WriteRequestMarshaller marshaller = new WriteRequestMarshaller();
        WriteRequest msg1 = this.buildRequest("test1".getBytes());
        marshaller.offerBuffer((DataBuffer)new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)msg1.getChunk().getData().asReadOnlyByteBuffer())), (Object)msg1);
        DataBuffer data = marshaller.pollBuffer((Object)msg1);
        Assert.assertNotNull((Object)data);
        data.release();
        marshaller.close();
        WriteRequest msg2 = this.buildRequest("test2".getBytes());
        marshaller.offerBuffer((DataBuffer)new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)msg2.getChunk().getData().asReadOnlyByteBuffer())), (Object)msg2);
        Assert.assertNull((Object)marshaller.pollBuffer((Object)msg1));
        Assert.assertNull((Object)marshaller.pollBuffer((Object)msg2));
    }

    private WriteRequest buildRequest(byte[] data) {
        return WriteRequest.newBuilder().setChunk(Chunk.newBuilder().setData(ByteString.copyFrom((byte[])data))).build();
    }
}

