/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.Chunk;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.ReadResponseMarshaller;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import com.google.protobuf.ByteString;
import io.grpc.Drainable;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class ReadResponseMarshallerTest {
    @Test
    public void streamEmptyMessage() throws Exception {
        this.validateStream(ReadResponse.getDefaultInstance());
    }

    @Test
    public void streamMessage() throws Exception {
        this.validateStream(this.buildResponse("test".getBytes()));
    }

    @Test
    public void parseEmptyMessage() throws Exception {
        this.validateParse(ReadResponse.getDefaultInstance());
    }

    @Test
    public void parseMessage() throws Exception {
        this.validateParse(this.buildResponse("test".getBytes()));
    }

    @Test
    public void close() {
        ReadResponseMarshaller marshaller = new ReadResponseMarshaller();
        ReadResponse msg1 = this.buildResponse("test1".getBytes());
        marshaller.offerBuffer((DataBuffer)new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)msg1.getChunk().getData().asReadOnlyByteBuffer())), (Object)msg1);
        DataBuffer data = marshaller.pollBuffer((Object)msg1);
        Assert.assertNotNull((Object)data);
        data.release();
        marshaller.close();
        ReadResponse msg2 = this.buildResponse("test2".getBytes());
        marshaller.offerBuffer((DataBuffer)new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)msg2.getChunk().getData().asReadOnlyByteBuffer())), (Object)msg2);
        Assert.assertNull((Object)marshaller.pollBuffer((Object)msg1));
        Assert.assertNull((Object)marshaller.pollBuffer((Object)msg2));
    }

    private void validateStream(ReadResponse message) throws IOException {
        ReadResponseMarshaller marshaller = new ReadResponseMarshaller();
        byte[] expected = message.toByteArray();
        if (message.hasChunk() && message.getChunk().hasData()) {
            marshaller.offerBuffer((DataBuffer)new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)message.getChunk().getData().asReadOnlyByteBuffer())), (Object)message);
        }
        InputStream stream = marshaller.stream((Object)message);
        Assert.assertTrue((boolean)(stream instanceof Drainable));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((Drainable)stream).drainTo((OutputStream)outputStream);
        Assert.assertArrayEquals((byte[])expected, (byte[])outputStream.toByteArray());
    }

    private void validateParse(ReadResponse message) {
        ReadResponseMarshaller marshaller = new ReadResponseMarshaller();
        byte[] data = message.toByteArray();
        ReadResponse parsedMessage = (ReadResponse)marshaller.parse((InputStream)new ByteArrayInputStream(data));
        if (data.length > 0) {
            DataBuffer buffer = marshaller.pollBuffer((Object)parsedMessage);
            Assert.assertNotNull((Object)buffer);
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes, 0, bytes.length);
            parsedMessage = parsedMessage.toBuilder().setChunk(Chunk.newBuilder().setData(ByteString.copyFrom((byte[])bytes)).build()).build();
        }
        Assert.assertEquals((Object)message, (Object)parsedMessage);
    }

    private ReadResponse buildResponse(byte[] data) {
        return ReadResponse.newBuilder().setChunk(Chunk.newBuilder().setData(ByteString.copyFrom((byte[])data))).build();
    }
}

