/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcConnection;
import alluxio.grpc.GrpcConnectionPool;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.security.user.UserState;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class GrpcConnectionPoolTest {
    private static InstancedConfiguration sConf = ConfigurationTestUtils.defaults();

    @BeforeClass
    public static void classSetup() {
        sConf.set(PropertyKey.NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT, (Object)"1sec");
        sConf.set(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_GRACEFUL_TIMEOUT, (Object)"500ms");
        sConf.set(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT, (Object)"1sec");
    }

    @After
    public void after() throws Exception {
        sConf = ConfigurationTestUtils.defaults();
    }

    @Test
    public void testEqualKeys() throws Exception {
        try (CloseableTestServer server = this.createServer();){
            GrpcChannelKey key1 = GrpcChannelKey.create((AlluxioConfiguration)sConf).setServerAddress(server.getConnectAddress());
            GrpcChannelKey key2 = GrpcChannelKey.create((AlluxioConfiguration)sConf).setServerAddress(server.getConnectAddress());
            GrpcConnection conn1 = GrpcConnectionPool.INSTANCE.acquireConnection(key1, (AlluxioConfiguration)sConf);
            GrpcConnection conn2 = GrpcConnectionPool.INSTANCE.acquireConnection(key2, (AlluxioConfiguration)sConf);
            Assert.assertEquals((Object)conn1, (Object)conn2);
        }
    }

    @Test
    public void testUnhealthyChannelRecreation() throws Exception {
        GrpcChannelKey key = GrpcChannelKey.create((AlluxioConfiguration)sConf);
        GrpcServerAddress address = GrpcServerAddress.create((InetSocketAddress)new InetSocketAddress("localhost", 1));
        key.setServerAddress(address);
        GrpcConnection conn1 = GrpcConnectionPool.INSTANCE.acquireConnection(key, (AlluxioConfiguration)sConf);
        GrpcConnection conn2 = GrpcConnectionPool.INSTANCE.acquireConnection(key, (AlluxioConfiguration)sConf);
        Assert.assertNotEquals((Object)conn1, (Object)conn2);
    }

    @Test
    public void testDifferentKeys() throws Exception {
        try (CloseableTestServer server1 = this.createServer();
             CloseableTestServer server2 = this.createServer();){
            GrpcChannelKey key1 = GrpcChannelKey.create((AlluxioConfiguration)sConf).setServerAddress(server1.getConnectAddress());
            GrpcChannelKey key2 = GrpcChannelKey.create((AlluxioConfiguration)sConf).setServerAddress(server2.getConnectAddress());
            GrpcConnection conn1 = GrpcConnectionPool.INSTANCE.acquireConnection(key1, (AlluxioConfiguration)sConf);
            GrpcConnection conn2 = GrpcConnectionPool.INSTANCE.acquireConnection(key2, (AlluxioConfiguration)sConf);
            Assert.assertNotEquals((Object)conn1, (Object)conn2);
        }
    }

    @Test
    public void testRoundRobin() throws Exception {
        int streamingGroupSize = sConf.getInt(PropertyKey.USER_NETWORK_STREAMING_MAX_CONNECTIONS);
        try (CloseableTestServer server = this.createServer();){
            ArrayList<GrpcChannelKey> keys = new ArrayList<GrpcChannelKey>(streamingGroupSize);
            for (int i = 0; i < streamingGroupSize; ++i) {
                keys.add(GrpcChannelKey.create((AlluxioConfiguration)sConf).setNetworkGroup(GrpcNetworkGroup.STREAMING).setServerAddress(server.getConnectAddress()));
            }
            List connections = keys.stream().map(key -> GrpcConnectionPool.INSTANCE.acquireConnection(key, (AlluxioConfiguration)sConf)).collect(Collectors.toList());
            Assert.assertEquals((long)streamingGroupSize, (long)connections.stream().distinct().collect(Collectors.toList()).size());
        }
    }

    @Test
    public void testGroupSize() throws Exception {
        int streamingGroupSize = sConf.getInt(PropertyKey.USER_NETWORK_STREAMING_MAX_CONNECTIONS);
        int acquireCount = streamingGroupSize * 100;
        try (CloseableTestServer server = this.createServer();){
            ArrayList<GrpcChannelKey> keys = new ArrayList<GrpcChannelKey>(acquireCount);
            for (int i = 0; i < acquireCount; ++i) {
                keys.add(GrpcChannelKey.create((AlluxioConfiguration)sConf).setNetworkGroup(GrpcNetworkGroup.STREAMING).setServerAddress(server.getConnectAddress()));
            }
            List connections = keys.stream().map(key -> GrpcConnectionPool.INSTANCE.acquireConnection(key, (AlluxioConfiguration)sConf)).collect(Collectors.toList());
            Assert.assertEquals((long)streamingGroupSize, (long)connections.stream().distinct().collect(Collectors.toList()).size());
        }
    }

    private CloseableTestServer createServer() throws Exception {
        InetSocketAddress bindAddress = new InetSocketAddress("0.0.0.0", 0);
        UserState us = UserState.Factory.create((AlluxioConfiguration)sConf);
        GrpcServer grpcServer = GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)"localhost", (SocketAddress)bindAddress), (AlluxioConfiguration)sConf, (UserState)us).build().start();
        return new CloseableTestServer(grpcServer);
    }

    private class CloseableTestServer
    implements AutoCloseable {
        GrpcServer mServer;

        CloseableTestServer(GrpcServer server) {
            this.mServer = server;
        }

        GrpcServerAddress getConnectAddress() {
            return GrpcServerAddress.create((InetSocketAddress)new InetSocketAddress("localhost", this.mServer.getBindPort()));
        }

        @Override
        public void close() throws Exception {
            this.mServer.shutdown();
        }
    }
}

