/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.conf.path.TrieNode;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class TrieNodeTest {
    @Test
    public void hasTerminalIncludeChildren() {
        TrieNode node = new TrieNode();
        node.insert("/a/b");
        Assert.assertTrue((boolean)node.hasTerminal("/", true));
        Assert.assertFalse((boolean)node.hasTerminal("/c", true));
        Assert.assertTrue((boolean)node.hasTerminal("/a", true));
        Assert.assertTrue((boolean)node.hasTerminal("/a/b", true));
        Assert.assertTrue((boolean)node.hasTerminal("/a/b/c", true));
    }

    @Test
    public void hasTerminal() {
        TrieNode node = new TrieNode();
        node.insert("/a/b");
        Assert.assertFalse((boolean)node.hasTerminal("/", false));
        Assert.assertFalse((boolean)node.hasTerminal("/c", false));
        Assert.assertFalse((boolean)node.hasTerminal("/a", false));
        Assert.assertTrue((boolean)node.hasTerminal("/a/b", false));
        Assert.assertTrue((boolean)node.hasTerminal("/a/b/c", false));
    }

    @Test
    public void getCommonRoots() {
        TrieNode node = new TrieNode();
        TrieNode a = node.insert("/a");
        TrieNode b = node.insert("/a/b");
        TrieNode f = node.insert("/a/e/f");
        TrieNode d = node.insert("/c/d");
        TrieNode g = node.insert("/c/g");
        Set roots = Streams.stream((Iterator)node.getCommonRoots()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)roots.contains(a));
        Assert.assertFalse((boolean)roots.contains(b));
        Assert.assertTrue((boolean)roots.contains(d));
        Assert.assertFalse((boolean)roots.contains(f));
        Assert.assertTrue((boolean)roots.contains(g));
    }

    @Test
    public void deleteIfTrue() {
        TrieNode node = new TrieNode();
        TrieNode a = node.insert("/a");
        TrieNode b = node.insert("/a/b");
        TrieNode f = node.insert("/a/e/f");
        TrieNode d = node.insert("/c/d");
        TrieNode g = node.insert("/c/g");
        TrieNode h = node.insert("/u/h");
        Assert.assertTrue((boolean)node.search("/a/b").contains(b));
        TrieNode b2 = node.deleteIf("/a/b", n -> {
            Assert.assertEquals((Object)b, (Object)n);
            return true;
        });
        Assert.assertEquals((Object)b, (Object)b2);
        Assert.assertFalse((boolean)node.search("/a/b").contains(b));
        Assert.assertTrue((boolean)node.search("/a").contains(a));
        TrieNode a2 = node.deleteIf("/a", n -> {
            Assert.assertEquals((Object)a, (Object)n);
            return true;
        });
        Assert.assertEquals((Object)a, (Object)a2);
        Assert.assertFalse((boolean)node.search("/a").contains(a));
        Assert.assertTrue((boolean)node.search("/a/e/f").contains(f));
        TrieNode c2 = node.deleteIf("/c", n -> true);
        Assert.assertNull((Object)c2);
        Assert.assertTrue((boolean)node.search("/c/d").contains(d));
        Assert.assertTrue((boolean)node.search("/c/g").contains(g));
        TrieNode h2 = node.deleteIf("/u/h", n -> {
            Assert.assertEquals((Object)h, (Object)n);
            return true;
        });
        Assert.assertEquals((Object)h, (Object)h2);
        TrieNode nil = node.deleteIf("/n", n -> {
            Assert.fail();
            return true;
        });
        Assert.assertNull((Object)nil);
    }

    @Test
    public void deleteIfFalse() {
        TrieNode node = new TrieNode();
        TrieNode a = node.insert("/a");
        TrieNode b = node.insert("/a/b");
        Assert.assertTrue((boolean)node.search("/a/b").contains(b));
        TrieNode b2 = node.deleteIf("/a/b", n -> false);
        Assert.assertNull((Object)b2);
        Assert.assertTrue((boolean)node.search("/a").contains(a));
        TrieNode a2 = node.deleteIf("/a", n -> false);
        Assert.assertNull((Object)a2);
    }

    @Test
    public void deleteAndInsert() {
        TrieNode node = new TrieNode();
        TrieNode a = node.insert("/a");
        TrieNode b = node.insert("/a/b");
        Assert.assertTrue((boolean)node.search("/a/b").contains(b));
        TrieNode b2 = node.deleteIf("/a/b", n -> {
            Assert.assertEquals((Object)b, (Object)n);
            return true;
        });
        Assert.assertEquals((Object)b, (Object)b2);
        Assert.assertFalse((boolean)node.search("/a/b").contains(b));
        TrieNode b3 = node.insert("/a/b");
        Assert.assertTrue((boolean)node.search("/a/b").contains(b3));
        Assert.assertTrue((boolean)node.search("/a").contains(a));
        Assert.assertTrue((boolean)node.search("/a/b").contains(a));
        TrieNode a2 = node.deleteIf("/a", n -> {
            Assert.assertEquals((Object)a, (Object)n);
            return true;
        });
        Assert.assertEquals((Object)a, (Object)a2);
        Assert.assertFalse((boolean)node.search("/a/b").contains(a));
        Assert.assertFalse((boolean)node.search("/a").contains(a));
        Assert.assertTrue((boolean)node.search("/a/b").contains(b3));
        TrieNode a3 = node.insert("/a");
        Assert.assertTrue((boolean)node.search("/a/b").contains(b3));
        Assert.assertTrue((boolean)node.search("/a").contains(a3));
        Assert.assertTrue((boolean)node.search("/a/b").contains(a3));
    }
}

