/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.AlluxioURI;
import alluxio.conf.path.PrefixPathMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class PrefixPathMatcherTest {
    @Test
    public void empty() {
        PrefixPathMatcher matcher = new PrefixPathMatcher(Collections.emptySet());
        this.checkNoMatch(matcher, "/");
        this.checkNoMatch(matcher, "/a");
        this.checkNoMatch(matcher, "/a/bc");
    }

    @Test
    public void root() {
        HashSet<String> paths = new HashSet<String>();
        paths.add("/");
        PrefixPathMatcher matcher = new PrefixPathMatcher(paths);
        this.checkMatch(matcher, "/", "/");
        this.checkMatch(matcher, "/a", "/");
        this.checkMatch(matcher, "/a/b", "/");
    }

    @Test
    public void match() {
        String[] paths = new String[]{"/a", "/a/b/", "/a/b/c", "/a/bc"};
        HashSet pathSet = new HashSet();
        Collections.addAll(pathSet, paths);
        PrefixPathMatcher matcher = new PrefixPathMatcher(pathSet);
        this.checkNoMatch(matcher, "/");
        this.checkNoMatch(matcher, "/ab");
        this.checkNoMatch(matcher, "/b");
        this.checkMatch(matcher, "/a", "/a");
        this.checkMatch(matcher, "/a/", "/a");
        this.checkMatch(matcher, "/a/bd", "/a");
        this.checkMatch(matcher, "/a/b", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/b/", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/b/d", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/b/cd", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/b/c", "/a/b/c", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/b/c/d", "/a/b/c", "/a/b/", "/a");
        this.checkMatch(matcher, "/a/bc", "/a/bc", "/a");
        this.checkMatch(matcher, "/a/bc/d", "/a/bc", "/a");
    }

    @Test
    public void matchWithNoLeadingSlash() {
        HashSet<String> paths = new HashSet<String>();
        paths.add("/a/b");
        PrefixPathMatcher matcher = new PrefixPathMatcher(paths);
        this.checkNoMatch(matcher, "a");
        this.checkNoMatch(matcher, "a/b");
    }

    private void checkMatch(PrefixPathMatcher matcher, String path, String ... expected) {
        Optional paths = matcher.match(new AlluxioURI(path));
        Assert.assertTrue((boolean)paths.isPresent());
        Assert.assertArrayEquals((Object[])expected, (Object[])((List)paths.get()).toArray());
    }

    private void checkNoMatch(PrefixPathMatcher matcher, String path) {
        Assert.assertFalse((boolean)matcher.match(new AlluxioURI(path)).isPresent());
    }
}

