/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.DefaultSupplier;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class PropertyKeyTest {
    private PropertyKey mTestProperty = new PropertyKey.Builder("alluxio.test.property").setAlias(new String[]{"alluxio.test.property.alias1", "alluxio.test.property.alias2"}).setDescription("test").setDefaultValue((Object)false).setIsHidden(false).setIgnoredSiteProperty(false).build();

    @After
    public void after() {
        PropertyKey.unregister((PropertyKey)this.mTestProperty);
    }

    @Test
    public void fromString() throws Exception {
        Assert.assertEquals((Object)PropertyKey.VERSION, (Object)PropertyKey.fromString((String)PropertyKey.VERSION.toString()));
        PropertyKey.fromString((String)PropertyKey.VERSION.toString());
        Assert.assertEquals((Object)this.mTestProperty, (Object)PropertyKey.fromString((String)"alluxio.test.property.alias1"));
        Assert.assertEquals((Object)this.mTestProperty, (Object)PropertyKey.fromString((String)"alluxio.test.property.alias2"));
        Assert.assertEquals((Object)this.mTestProperty, (Object)PropertyKey.fromString((String)this.mTestProperty.toString()));
    }

    @Test
    public void equalsTest() throws Exception {
        Assert.assertEquals((Object)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.format(new Object[]{"foo"}), (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.format(new Object[]{"foo"}));
        Assert.assertEquals((Object)PropertyKey.HOME, (Object)PropertyKey.HOME);
    }

    @Test
    public void length() throws Exception {
        Assert.assertEquals((long)"alluxio.home".length(), (long)PropertyKey.HOME.length());
    }

    @Test
    public void isValid() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.isValid((String)PropertyKey.HOME.toString()));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.format(new Object[]{"foo"}).toString()));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)""));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)" "));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"foo"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)(PropertyKey.HOME.toString() + "1")));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)PropertyKey.HOME.toString().toUpperCase()));
    }

    @Test
    public void aliasIsValid() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.isValid((String)this.mTestProperty.toString()));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.test.property.alias1"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.test.property.alias2"));
    }

    @Test
    public void fromStringExceptionThrown() throws Exception {
        String[] wrongKeys;
        for (String key : wrongKeys = new String[]{"", " ", "foo", "alluxio.foo", "alluxio.HOME", "alluxio.master.mount.table.root.alluxio1", "alluxio.master.mount.table.alluxio", "alluxio.master.mount.table.foo"}) {
            try {
                PropertyKey.fromString((String)key);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)ExceptionMessage.INVALID_CONFIGURATION_KEY.getMessage(new Object[]{key}));
            }
        }
    }

    @Test
    public void formatMasterTieredStoreGlobalAlias() throws Exception {
        Assert.assertEquals((Object)PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS, (Object)PropertyKey.Template.MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS.format(new Object[]{0}));
        Assert.assertEquals((Object)PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS, (Object)PropertyKey.Template.MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS.format(new Object[]{1}));
        Assert.assertEquals((Object)PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS, (Object)PropertyKey.Template.MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS.format(new Object[]{2}));
    }

    @Test
    public void formatWorkerTieredStoreAlias() throws Exception {
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL0_ALIAS, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{0}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL1_ALIAS, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{1}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL2_ALIAS, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{2}));
    }

    @Test
    public void formatWorkerTieredStoreDirsPath() throws Exception {
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL1_DIRS_PATH, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{1}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL2_DIRS_PATH, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{2}));
    }

    @Test
    public void formatWorkerTieredStoreDirsQuota() throws Exception {
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{0}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL1_DIRS_QUOTA, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{1}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL2_DIRS_QUOTA, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{2}));
    }

    @Test
    public void formatWorkerTieredStoreReservedRatio() throws Exception {
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL0_HIGH_WATERMARK_RATIO, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO.format(new Object[]{0}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL1_HIGH_WATERMARK_RATIO, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO.format(new Object[]{1}));
        Assert.assertEquals((Object)PropertyKey.WORKER_TIERED_STORE_LEVEL2_HIGH_WATERMARK_RATIO, (Object)PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO.format(new Object[]{2}));
    }

    @Test
    public void mountTableRootProperties() throws Exception {
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_ALLUXIO, (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.format(new Object[]{"root"}));
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_UFS.format(new Object[]{"root"}));
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_READONLY, (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_READONLY.format(new Object[]{"root"}));
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_SHARED, (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_SHARED.format(new Object[]{"root"}));
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION, (Object)PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION.format(new Object[]{"root"}));
    }

    @Test
    public void isValidParameterized() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.foo.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.FoO.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.Fo123.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.FoO.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.option"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.option.foo"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.option.alluxio.foo"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.alluxio"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table..alluxio"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table. .alluxio"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.foo.alluxio1"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.option."));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.master.mount.table.root.option.foo."));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.worker.tieredstore.level1.alias"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.worker.tieredstore.level99.alias"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.worker.tieredstore.level.alias"));
        Assert.assertFalse((boolean)PropertyKey.isValid((String)"alluxio.worker.tieredstore.levela.alias"));
    }

    @Test
    public void fromStringParameterized() throws Exception {
        Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_ALLUXIO, (Object)PropertyKey.fromString((String)"alluxio.master.mount.table.root.alluxio"));
        Assert.assertEquals((Object)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.format(new Object[]{"foo"}), (Object)PropertyKey.fromString((String)"alluxio.master.mount.table.foo.alluxio"));
    }

    @Test
    public void fromStringParameterizedExceptionThrown() throws Exception {
        String[] wrongKeys;
        for (String key : wrongKeys = new String[]{"alluxio.master.mount.table.root.alluxio1", "alluxio.master.mount.table.alluxio", "alluxio.master.mount.table.foo"}) {
            try {
                PropertyKey.fromString((String)key);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)ExceptionMessage.INVALID_CONFIGURATION_KEY.getMessage(new Object[]{key}));
            }
        }
    }

    @Test
    public void defaultSupplier() throws Exception {
        AtomicInteger x = new AtomicInteger(100);
        PropertyKey key = new PropertyKey.Builder("test").setDefaultSupplier(new DefaultSupplier(() -> x.get(), "test description")).build();
        Assert.assertEquals((Object)"100", (Object)key.getDefaultValue());
        x.set(20);
        Assert.assertEquals((Object)"20", (Object)key.getDefaultValue());
        Assert.assertEquals((Object)"test description", (Object)key.getDefaultSupplier().getDescription());
    }

    @Test
    public void isDeprecated() throws Exception {
        Assert.assertFalse((boolean)PropertyKey.isDeprecated((String)"alluxio.version"));
    }

    @Test
    public void compare() throws Exception {
        Assert.assertTrue((PropertyKey.CONF_DIR.compareTo(PropertyKey.DEBUG) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PropertyKey.DEBUG.compareTo(PropertyKey.CONF_DIR) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)PropertyKey.DEBUG.compareTo(PropertyKey.DEBUG));
    }

    @Test
    public void templateMatches() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.matches("alluxio.master.mount.table.root.alluxio"));
        Assert.assertTrue((boolean)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.matches("alluxio.master.mount.table.ufs123.alluxio"));
        Assert.assertFalse((boolean)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.matches("alluxio.master.mount.table..alluxio"));
        Assert.assertFalse((boolean)PropertyKey.Template.MASTER_MOUNT_TABLE_ALLUXIO.matches("alluxio.master.mount.table.alluxio"));
    }

    @Test
    public void localityTemplates() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.locality.node"));
        Assert.assertTrue((boolean)PropertyKey.isValid((String)"alluxio.locality.custom"));
        Assert.assertEquals((Object)"alluxio.locality.custom", (Object)PropertyKey.Template.LOCALITY_TIER.format(new Object[]{"custom"}).toString());
    }

    @Test
    public void isBuiltIn() {
        Assert.assertTrue((boolean)this.mTestProperty.isBuiltIn());
    }

    @Test
    public void impersonationRegex() {
        String name = "a-A_1.b-B_2@.groups";
        String groups = String.format("alluxio.master.security.impersonation.%s.groups", name);
        Matcher matcher = PropertyKey.Template.MASTER_IMPERSONATION_GROUPS_OPTION.match(groups);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((Object)name, (Object)matcher.group(1));
        name = "a-A_1.b-B_2@.users";
        String users = String.format("alluxio.master.security.impersonation.%s.users", name);
        matcher = PropertyKey.Template.MASTER_IMPERSONATION_USERS_OPTION.match(users);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((Object)name, (Object)matcher.group(1));
    }

    @Test
    public void testEmptyKeyDefaults() {
        for (PropertyKey key : PropertyKey.defaultKeys()) {
            Assert.assertNotEquals((String)String.format("Property keys cannot have a default value of \"\". Offending key: %s", key.getName()), (Object)key.getDefaultValue(), (Object)"");
        }
    }

    @Test
    public void testKeyIsDeprecatedOrRemoved() throws Exception {
        Assert.assertTrue((boolean)PropertyKey.isDeprecated((String)PropertyKey.TEST_DEPRECATED_KEY.getName()));
        Assert.assertTrue((boolean)PropertyKey.isDeprecated((PropertyKey)PropertyKey.TEST_DEPRECATED_KEY));
        Assert.assertTrue((boolean)PropertyKey.isDeprecated((PropertyKey)PropertyKey.Template.TEST_DEPRECATED_TEMPLATE.format(new Object[]{"removed"})));
        Assert.assertTrue((boolean)PropertyKey.isRemoved((String)"alluxio.test.removed.key"));
    }

    @Test
    public void testGetOrBuildCustom() throws Exception {
        PropertyKey workerHostName = PropertyKey.getOrBuildCustom((String)"alluxio.worker.hostname");
        Assert.assertTrue((PropertyKey.WORKER_HOSTNAME == workerHostName ? 1 : 0) != 0);
        PropertyKey test = PropertyKey.getOrBuildCustom((String)"test");
        Assert.assertEquals((Object)PropertyKey.DisplayType.DEFAULT, (Object)test.getDisplayType());
        Assert.assertEquals((Object)"test", (Object)test.getName());
        Assert.assertTrue((test == PropertyKey.getOrBuildCustom((String)"test") ? 1 : 0) != 0);
        PropertyKey accessKey = PropertyKey.getOrBuildCustom((String)"test.accessKeyId");
        Assert.assertEquals((Object)PropertyKey.DisplayType.CREDENTIALS, (Object)accessKey.getDisplayType());
    }
}

