/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.AlluxioTestDirectory;
import alluxio.ConfigurationTestUtils;
import alluxio.DefaultSupplier;
import alluxio.SystemPropertyRule;
import alluxio.TestLoggerRule;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.test.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class InstancedConfigurationTest {
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    @Rule
    public final TemporaryFolder mFolder = new TemporaryFolder();
    @Rule
    public final TestLoggerRule mLogger = new TestLoggerRule();

    @Before
    public void before() {
        this.resetConf();
    }

    public void resetConf() {
        ConfigurationUtils.reloadProperties();
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @AfterClass
    public static void after() {
        ConfigurationUtils.reloadProperties();
    }

    @Test
    public void defaultLoggerCorrectlyLoaded() throws Exception {
        try (Closeable p = new SystemPropertyRule(PropertyKey.LOGGER_TYPE.toString(), null).toResource();){
            String loggerType = this.mConfiguration.get(PropertyKey.LOGGER_TYPE);
            Assert.assertEquals((Object)"Console", (Object)loggerType);
        }
    }

    @Test
    public void alias() throws Exception {
        try (Closeable p = new SystemPropertyRule("alluxio.master.worker.timeout.ms", "100").toResource();){
            this.resetConf();
            Assert.assertEquals((long)100L, (long)this.mConfiguration.getMs(PropertyKey.MASTER_WORKER_TIMEOUT_MS));
        }
    }

    @Test
    public void isSet() {
        Assert.assertFalse((boolean)this.mConfiguration.isSet(PropertyKey.ZOOKEEPER_ADDRESS));
        this.mConfiguration.set(PropertyKey.ZOOKEEPER_ADDRESS, (Object)"address");
        Assert.assertTrue((boolean)this.mConfiguration.isSet(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    @Test
    public void isSetResolve() {
        this.mConfiguration.unset(PropertyKey.MASTER_HOSTNAME);
        this.mConfiguration.set(PropertyKey.MASTER_WEB_HOSTNAME, (Object)"${alluxio.master.hostname}");
        Assert.assertFalse((boolean)this.mConfiguration.isSet(PropertyKey.MASTER_WEB_HOSTNAME));
        this.mConfiguration.set(PropertyKey.MASTER_HOSTNAME, (Object)"localhost");
        Assert.assertTrue((boolean)this.mConfiguration.isSet(PropertyKey.MASTER_WEB_HOSTNAME));
    }

    @Test
    public void getInt() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"1");
        Assert.assertEquals((long)1L, (long)this.mConfiguration.getInt(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getMalformedIntThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"9448367483758473854738");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getInt(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getLong() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"12345678910");
        Assert.assertEquals((long)12345678910L, (long)this.mConfiguration.getLong(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getMalformedLongThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"999999999999999999999999999999999999");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getLong(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getDouble() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"1.1");
        Assert.assertEquals((double)1.1, (double)this.mConfiguration.getDouble(PropertyKey.WEB_THREADS), (double)1.0E-4);
    }

    @Test
    public void getMalformedDoubleThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"1a");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getDouble(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getFloat() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"1.1");
        Assert.assertEquals((double)1.1, (double)this.mConfiguration.getFloat(PropertyKey.WEB_THREADS), (double)1.0E-4);
    }

    @Test
    public void getMalformedFloatThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"1a");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getFloat(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getTrueBoolean() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"true");
        Assert.assertTrue((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getTrueBooleanUppercase() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"True");
        Assert.assertTrue((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getTrueBooleanMixcase() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"tRuE");
        Assert.assertTrue((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getFalseBoolean() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"false");
        Assert.assertFalse((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getFalseBooleanUppercase() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"False");
        Assert.assertFalse((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getFalseBooleanMixcase() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"fAlSe");
        Assert.assertFalse((boolean)this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getMalformedBooleanThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"x");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getList() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"a,b,c");
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (Object)this.mConfiguration.getList(PropertyKey.WEB_THREADS, ","));
    }

    @Test
    public void getEnum() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"VALUE");
        Assert.assertEquals((Object)((Object)TestEnum.VALUE), (Object)this.mConfiguration.getEnum(PropertyKey.WEB_THREADS, TestEnum.class));
    }

    @Test
    public void getMalformedEnum() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"not_a_value");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getEnum(PropertyKey.WEB_THREADS, TestEnum.class);
    }

    @Test
    public void getBytes() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10b");
        Assert.assertEquals((long)10L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytesKb() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10kb");
        Assert.assertEquals((long)10240L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytesMb() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10mb");
        Assert.assertEquals((long)0xA00000L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytesGb() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10gb");
        Assert.assertEquals((long)0x280000000L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytesGbUppercase() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10GB");
        Assert.assertEquals((long)0x280000000L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytesTb() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10tb");
        Assert.assertEquals((long)0xA0000000000L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getBytespT() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"10pb");
        Assert.assertEquals((long)0x28000000000000L, (long)this.mConfiguration.getBytes(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getMalformedBytesThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"100a");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getBoolean(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getMs() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"100");
        Assert.assertEquals((long)100L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsMS() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"100ms");
        Assert.assertEquals((long)100L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsMillisecond() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"100millisecond");
        Assert.assertEquals((long)100L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsS() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10s");
        Assert.assertEquals((long)10000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsSUppercase() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10S");
        Assert.assertEquals((long)10000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsSEC() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10sec");
        Assert.assertEquals((long)10000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsSecond() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10second");
        Assert.assertEquals((long)10000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsM() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10m");
        Assert.assertEquals((long)600000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsMIN() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10min");
        Assert.assertEquals((long)600000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsMinute() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10minute");
        Assert.assertEquals((long)600000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsH() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10h");
        Assert.assertEquals((long)36000000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsHR() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10hr");
        Assert.assertEquals((long)36000000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsHour() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10hour");
        Assert.assertEquals((long)36000000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsD() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10d");
        Assert.assertEquals((long)864000000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getMsDay() {
        this.mConfiguration.set(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS, (Object)"10day");
        Assert.assertEquals((long)864000000L, (long)this.mConfiguration.getMs(PropertyKey.PROXY_STREAM_CACHE_TIMEOUT_MS));
    }

    @Test
    public void getNegativeSyncInterval() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"-1");
        Assert.assertEquals((long)-1L, (long)this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
    }

    @Test
    public void getNegativeSyncIntervalS() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"-1s");
        Assert.assertTrue((this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void getZeroSyncInterval() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"0");
        Assert.assertEquals((long)0L, (long)this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
    }

    @Test
    public void getZeroSyncIntervalS() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"0s");
        Assert.assertEquals((long)0L, (long)this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
    }

    @Test
    public void getPositiveSyncInterval() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"10");
        Assert.assertEquals((long)10L, (long)this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
    }

    @Test
    public void getPosiviteSyncIntervalS() {
        this.mConfiguration.set(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"10s");
        Assert.assertEquals((long)10000L, (long)this.mConfiguration.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
    }

    @Test
    public void getUnsetValueThrowsException() {
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.get(PropertyKey.S3A_ACCESS_KEY);
    }

    @Test
    public void getNestedProperties() {
        this.mConfiguration.set(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION_PROPERTY.format(new Object[]{"foo", PropertyKey.WEB_THREADS.toString()}), (Object)"val1");
        this.mConfiguration.set(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION_PROPERTY.format(new Object[]{"foo", "alluxio.unknown.property"}), (Object)"val2");
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(PropertyKey.WEB_THREADS.toString(), "val1");
        expected.put("alluxio.unknown.property", "val2");
        Assert.assertThat((Object)this.mConfiguration.getNestedProperties(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION.format(new Object[]{"foo"})), (Matcher)CoreMatchers.is(expected));
    }

    @Test
    public void getNestedPropertiesEmptyTrailingProperty() {
        this.mConfiguration.set(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION_PROPERTY.format(new Object[]{"foo", ""}), (Object)"val");
        HashMap empty = new HashMap();
        Assert.assertThat((Object)this.mConfiguration.getNestedProperties(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION.format(new Object[]{"foo"})), (Matcher)CoreMatchers.is(empty));
    }

    @Test
    public void getNestedPropertiesWrongPrefix() {
        this.mConfiguration.set(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION_PROPERTY.format(new Object[]{"foo", PropertyKey.WEB_THREADS.toString()}), (Object)"val");
        HashMap empty = new HashMap();
        Assert.assertThat((Object)this.mConfiguration.getNestedProperties(PropertyKey.HOME), (Matcher)CoreMatchers.is(empty));
        Assert.assertThat((Object)this.mConfiguration.getNestedProperties(PropertyKey.Template.MASTER_MOUNT_TABLE_OPTION.format(new Object[]{"bar"})), (Matcher)CoreMatchers.is(empty));
    }

    @Test
    public void getClassTest() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"java.lang.String");
        Assert.assertEquals(String.class, (Object)this.mConfiguration.getClass(PropertyKey.WEB_THREADS));
    }

    @Test
    public void getMalformedClassThrowsException() {
        this.mConfiguration.set(PropertyKey.WEB_THREADS, (Object)"java.util.not.a.class");
        this.mThrown.expect(RuntimeException.class);
        this.mConfiguration.getClass(PropertyKey.WEB_THREADS);
    }

    @Test
    public void getTemplatedKey() {
        this.mConfiguration.set(PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS, (Object)"test");
        Assert.assertEquals((Object)"test", (Object)this.mConfiguration.get(PropertyKey.Template.MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS.format(new Object[]{0})));
    }

    @Test
    public void variableSubstitution() {
        this.mConfiguration.merge((Map)ImmutableMap.of((Object)PropertyKey.WORK_DIR, (Object)"value", (Object)PropertyKey.LOGS_DIR, (Object)"${alluxio.work.dir}/logs"), Source.SYSTEM_PROPERTY);
        String substitution = this.mConfiguration.get(PropertyKey.LOGS_DIR);
        Assert.assertEquals((Object)"value/logs", (Object)substitution);
    }

    @Test
    public void twoVariableSubstitution() {
        this.mConfiguration.merge((Map)ImmutableMap.of((Object)PropertyKey.MASTER_HOSTNAME, (Object)"value1", (Object)PropertyKey.MASTER_RPC_PORT, (Object)"value2", (Object)PropertyKey.MASTER_JOURNAL_FOLDER, (Object)"${alluxio.master.hostname}-${alluxio.master.rpc.port}"), Source.SYSTEM_PROPERTY);
        String substitution = this.mConfiguration.get(PropertyKey.MASTER_JOURNAL_FOLDER);
        Assert.assertEquals((Object)"value1-value2", (Object)substitution);
    }

    @Test
    public void recursiveVariableSubstitution() {
        this.mConfiguration.merge((Map)ImmutableMap.of((Object)PropertyKey.WORK_DIR, (Object)"value", (Object)PropertyKey.LOGS_DIR, (Object)"${alluxio.work.dir}/logs", (Object)PropertyKey.SITE_CONF_DIR, (Object)"${alluxio.logs.dir}/conf"), Source.SYSTEM_PROPERTY);
        String substitution2 = this.mConfiguration.get(PropertyKey.SITE_CONF_DIR);
        Assert.assertEquals((Object)"value/logs/conf", (Object)substitution2);
    }

    @Test
    public void systemVariableSubstitution() throws Exception {
        try (Closeable p = new SystemPropertyRule(PropertyKey.MASTER_HOSTNAME.toString(), "new_master").toResource();){
            this.resetConf();
            Assert.assertEquals((Object)"new_master", (Object)this.mConfiguration.get(PropertyKey.MASTER_HOSTNAME));
        }
    }

    @Test
    public void systemPropertySubstitution() throws Exception {
        try (Closeable p = new SystemPropertyRule("user.home", "/home").toResource();){
            this.resetConf();
            this.mConfiguration.set(PropertyKey.WORK_DIR, (Object)"${user.home}/work");
            Assert.assertEquals((Object)"/home/work", (Object)this.mConfiguration.get(PropertyKey.WORK_DIR));
        }
    }

    @Test
    public void circularSubstitution() throws Exception {
        this.mConfiguration.set(PropertyKey.HOME, (Object)String.format("${%s}", PropertyKey.HOME.toString()));
        this.mThrown.expect(RuntimeException.class);
        this.mThrown.expectMessage(PropertyKey.HOME.toString());
        this.mConfiguration.get(PropertyKey.HOME);
    }

    @Test
    public void userFileBufferBytesOverFlowException() {
        this.mConfiguration.set(PropertyKey.USER_FILE_BUFFER_BYTES, (Object)(String.valueOf(Integer.MIN_VALUE) + "B"));
        this.mThrown.expect(IllegalStateException.class);
        this.mConfiguration.validate();
    }

    @Test
    public void shortMasterHeartBeatTimeout() {
        this.mConfiguration.set(PropertyKey.MASTER_STANDBY_HEARTBEAT_INTERVAL, (Object)"5min");
        this.mConfiguration.set(PropertyKey.MASTER_HEARTBEAT_TIMEOUT, (Object)"4min");
        this.mThrown.expect(IllegalStateException.class);
        this.mConfiguration.validate();
    }

    @Test
    public void setUserFileBufferBytesMaxInteger() {
        this.mConfiguration.set(PropertyKey.USER_FILE_BUFFER_BYTES, (Object)(String.valueOf(Integer.MAX_VALUE) + "B"));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)this.mConfiguration.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES)));
    }

    @Test
    public void setUserFileBufferBytes1GB() {
        this.mConfiguration.set(PropertyKey.USER_FILE_BUFFER_BYTES, (Object)"1GB");
        Assert.assertEquals((long)0x40000000L, (long)((int)this.mConfiguration.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES)));
    }

    @Test
    public void unset() {
        Assert.assertFalse((boolean)this.mConfiguration.isSet(PropertyKey.SECURITY_LOGIN_USERNAME));
        this.mConfiguration.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"test");
        Assert.assertTrue((boolean)this.mConfiguration.isSet(PropertyKey.SECURITY_LOGIN_USERNAME));
        this.mConfiguration.unset(PropertyKey.SECURITY_LOGIN_USERNAME);
        Assert.assertFalse((boolean)this.mConfiguration.isSet(PropertyKey.SECURITY_LOGIN_USERNAME));
    }

    @Test
    public void validateTieredLocality() throws Exception {
        this.resetConf();
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.Template.LOCALITY_TIER.format(new Object[]{"unknownTier"}).toString(), "val");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.mThrown.expect(IllegalStateException.class);
            this.mThrown.expectMessage("Tier unknownTier is configured by alluxio.locality.unknownTier, but does not exist in the tier list [node, rack] configured by alluxio.locality.order");
            this.resetConf();
        }
    }

    @Test
    public void propertyTestModeEqualsTrue() throws Exception {
        Assert.assertTrue((boolean)this.mConfiguration.getBoolean(PropertyKey.TEST_MODE));
    }

    @Test
    public void sitePropertiesNotLoadedInTest() throws Exception {
        Properties props = new Properties();
        props.setProperty(PropertyKey.LOGGER_TYPE.toString(), "TEST_LOGGER");
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        props.store(new FileOutputStream(propsFile), "ignored header");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.LOGGER_TYPE.toString(), null);
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getCanonicalPath());
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.mConfiguration = ConfigurationTestUtils.defaults();
            Assert.assertEquals((Object)PropertyKey.LOGGER_TYPE.getDefaultValue(), (Object)this.mConfiguration.get(PropertyKey.LOGGER_TYPE));
        }
    }

    @Test
    public void sitePropertiesLoadedNotInTest() throws Exception {
        Properties props = new Properties();
        props.setProperty(PropertyKey.LOGGER_TYPE.toString(), "TEST_LOGGER");
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        props.store(new FileOutputStream(propsFile), "ignored header");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.LOGGER_TYPE.toString(), null);
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getAbsolutePath());
        sysProps.put(PropertyKey.TEST_MODE.toString(), "false");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.resetConf();
            Assert.assertEquals((Object)"TEST_LOGGER", (Object)this.mConfiguration.get(PropertyKey.LOGGER_TYPE));
        }
    }

    @Test
    public void setIgnoredPropertiesInSiteProperties() throws Exception {
        this.resetConf();
        Properties siteProps = new Properties();
        siteProps.setProperty(PropertyKey.LOGS_DIR.toString(), "/tmp/logs1");
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        siteProps.store(new FileOutputStream(propsFile), "tmp site properties file");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getAbsolutePath());
        sysProps.put(PropertyKey.TEST_MODE.toString(), "false");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.mThrown.expect(IllegalStateException.class);
            this.resetConf();
        }
    }

    @Test
    public void setIgnoredPropertiesInSystemProperties() throws Exception {
        Properties siteProps = new Properties();
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        siteProps.store(new FileOutputStream(propsFile), "tmp site properties file");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.LOGS_DIR.toString(), "/tmp/logs1");
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getAbsolutePath());
        sysProps.put(PropertyKey.TEST_MODE.toString(), "false");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.resetConf();
            Assert.assertEquals((Object)Source.SYSTEM_PROPERTY, (Object)this.mConfiguration.getSource(PropertyKey.LOGS_DIR));
            Assert.assertEquals((Object)"/tmp/logs1", (Object)this.mConfiguration.get(PropertyKey.LOGS_DIR));
        }
    }

    @Test
    public void noWhitespaceTrailingInSiteProperties() throws Exception {
        Properties siteProps = new Properties();
        siteProps.setProperty(PropertyKey.MASTER_HOSTNAME.toString(), " host-1 ");
        siteProps.setProperty(PropertyKey.WEB_THREADS.toString(), "\t123\t");
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        siteProps.store(new FileOutputStream(propsFile), "tmp site properties file");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getAbsolutePath());
        sysProps.put(PropertyKey.TEST_MODE.toString(), "false");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.resetConf();
            Assert.assertEquals((Object)"host-1", (Object)this.mConfiguration.get(PropertyKey.MASTER_HOSTNAME));
            Assert.assertEquals((Object)"123", (Object)this.mConfiguration.get(PropertyKey.WEB_THREADS));
        }
    }

    @Test
    public void source() throws Exception {
        Properties siteProps = new Properties();
        File propsFile = this.mFolder.newFile("alluxio-site.properties");
        siteProps.setProperty(PropertyKey.MASTER_HOSTNAME.toString(), "host-1");
        siteProps.setProperty(PropertyKey.MASTER_WEB_PORT.toString(), "1234");
        siteProps.store(new FileOutputStream(propsFile), "tmp site properties file");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.LOGS_DIR.toString(), "/tmp/logs1");
        sysProps.put(PropertyKey.MASTER_WEB_PORT.toString(), "4321");
        sysProps.put(PropertyKey.SITE_CONF_DIR.toString(), this.mFolder.getRoot().getAbsolutePath());
        sysProps.put(PropertyKey.TEST_MODE.toString(), "false");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            this.resetConf();
            Assert.assertEquals((Object)Source.Type.SITE_PROPERTY, (Object)this.mConfiguration.getSource(PropertyKey.MASTER_HOSTNAME).getType());
            Assert.assertEquals((Object)Source.SYSTEM_PROPERTY, (Object)this.mConfiguration.getSource(PropertyKey.MASTER_WEB_PORT));
            Assert.assertEquals((Object)Source.SYSTEM_PROPERTY, (Object)this.mConfiguration.getSource(PropertyKey.LOGS_DIR));
            Assert.assertEquals((Object)Source.DEFAULT, (Object)this.mConfiguration.getSource(PropertyKey.MASTER_RPC_PORT));
        }
    }

    @Test
    public void getRuntimeDefault() throws Exception {
        AtomicInteger x = new AtomicInteger(100);
        PropertyKey key = new PropertyKey.Builder("testKey").setDefaultSupplier(new DefaultSupplier(() -> x.get(), "finds x")).build();
        Assert.assertEquals((long)100L, (long)this.mConfiguration.getInt(key));
        x.set(20);
        Assert.assertEquals((long)20L, (long)this.mConfiguration.getInt(key));
    }

    @Test
    public void toMap() throws Exception {
        String testKeyName = "alluxio.extensions.dir";
        PropertyKey nestedKey = PropertyKey.SECURITY_LOGIN_USERNAME;
        String nestedValue = String.format("${%s}.test", testKeyName);
        this.mConfiguration.set(nestedKey, (Object)nestedValue);
        Map resolvedMap = this.mConfiguration.toMap();
        Assert.assertEquals((Object)this.mConfiguration.get(PropertyKey.fromString((String)testKeyName)), resolvedMap.get(testKeyName));
        String nestedResolvedValue = String.format("%s.test", resolvedMap.get(testKeyName));
        Assert.assertEquals((Object)nestedResolvedValue, resolvedMap.get(nestedKey.toString()));
        String resolvedValue1 = String.format("%s/extensions", resolvedMap.get("alluxio.home"));
        Assert.assertEquals((Object)resolvedValue1, resolvedMap.get(testKeyName));
        String resolvedValue2 = String.format("%s/logs", resolvedMap.get("alluxio.work.dir"));
        Assert.assertEquals((Object)resolvedValue2, resolvedMap.get("alluxio.logs.dir"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.debug"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.fuse.fs.name"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.master.journal.folder"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.proxy.web.port"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.security.authentication.type"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.user.block.master.client.pool.size.max"));
        Assert.assertTrue((boolean)resolvedMap.containsKey("alluxio.worker.bind.host"));
    }

    @Test
    public void toRawMap() throws Exception {
        PropertyKey testKey = PropertyKey.SECURITY_LOGIN_USERNAME;
        String testValue = String.format("${%s}.test", "alluxio.extensions.dir");
        this.mConfiguration.set(testKey, (Object)testValue);
        Map rawMap = this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useRawValue(true));
        Assert.assertEquals((Object)testValue, rawMap.get(testKey.toString()));
        String regexString = "(\\$\\{([^{}]*)\\})";
        Pattern confRegex = Pattern.compile(regexString);
        Assert.assertTrue((boolean)confRegex.matcher((CharSequence)rawMap.get("alluxio.logs.dir")).find());
    }

    @Test
    public void getCredentialsDisplayValue() {
        PropertyKey testKey = PropertyKey.S3A_SECRET_KEY;
        String testValue = "12345";
        Assert.assertEquals((Object)PropertyKey.DisplayType.CREDENTIALS, (Object)testKey.getDisplayType());
        this.mConfiguration.set(testKey, (Object)testValue);
        Assert.assertNotEquals((Object)testValue, (Object)this.mConfiguration.get(testKey, ConfigurationValueOptions.defaults().useDisplayValue(true)));
        Assert.assertNotEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true)).get(testKey.getName()));
    }

    @Test
    public void getDefaultDisplayValue() {
        PropertyKey testKey = PropertyKey.SECURITY_LOGIN_USERNAME;
        String testValue = "12345";
        Assert.assertEquals((Object)PropertyKey.DisplayType.DEFAULT, (Object)testKey.getDisplayType());
        this.mConfiguration.set(testKey, (Object)testValue);
        Assert.assertEquals((Object)testValue, (Object)this.mConfiguration.get(testKey, ConfigurationValueOptions.defaults().useDisplayValue(true)));
        Assert.assertEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true)).get(testKey.getName()));
    }

    @Test
    public void getNestedCredentialsDisplayValue() {
        PropertyKey nestedProperty = PropertyKey.fromString((String)"alluxio.master.journal.ufs.option.aws.secretKey");
        String testValue = "12345";
        this.mConfiguration.set(nestedProperty, (Object)testValue);
        Assert.assertNotEquals((Object)testValue, (Object)this.mConfiguration.get(nestedProperty, ConfigurationValueOptions.defaults().useDisplayValue(true)));
        Assert.assertNotEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true)).get(nestedProperty.getName()));
        Assert.assertNotEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true).useRawValue(true)).get(nestedProperty.getName()));
    }

    @Test
    public void getNestedDefaultDisplayValue() {
        PropertyKey nestedProperty = PropertyKey.fromString((String)"alluxio.master.journal.ufs.option.alluxio.underfs.hdfs.configuration");
        String testValue = "conf/core-site.xml:conf/hdfs-site.xml";
        this.mConfiguration.set(nestedProperty, (Object)testValue);
        Assert.assertEquals((Object)testValue, (Object)this.mConfiguration.get(nestedProperty, ConfigurationValueOptions.defaults().useDisplayValue(true)));
        Assert.assertEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true)).get(nestedProperty.getName()));
        Assert.assertEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true).useRawValue(true)).get(nestedProperty.getName()));
    }

    @Test
    public void getTemplateCredentialsDisplayValue() {
        PropertyKey templateProperty = PropertyKey.fromString((String)"fs.azure.account.key.someone.blob.core.windows.net");
        String testValue = "12345";
        this.mConfiguration.set(templateProperty, (Object)testValue);
        Assert.assertNotEquals((Object)testValue, (Object)this.mConfiguration.get(templateProperty, ConfigurationValueOptions.defaults().useDisplayValue(true)));
        Assert.assertNotEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true)).get(templateProperty.getName()));
        Assert.assertNotEquals((Object)testValue, this.mConfiguration.toMap(ConfigurationValueOptions.defaults().useDisplayValue(true).useRawValue(true)).get(templateProperty.getName()));
    }

    @Test
    public void getCredentialsDisplayValueIdentical() {
        PropertyKey testKey = PropertyKey.S3A_SECRET_KEY;
        String testValue = "12345";
        Assert.assertEquals((Object)PropertyKey.DisplayType.CREDENTIALS, (Object)testKey.getDisplayType());
        this.mConfiguration.set(testKey, (Object)testValue);
        String displayValue1 = this.mConfiguration.get(testKey, ConfigurationValueOptions.defaults().useDisplayValue(true));
        String testValue2 = "abc";
        this.mConfiguration.set(testKey, (Object)testValue2);
        String displayValue2 = this.mConfiguration.get(testKey, ConfigurationValueOptions.defaults().useDisplayValue(true));
        Assert.assertEquals((Object)displayValue1, (Object)displayValue2);
    }

    @Test
    public void extensionProperty() {
        String fakeKeyName = "fake.extension.key";
        this.mConfiguration.merge((Map)ImmutableMap.of((Object)fakeKeyName, (Object)"value"), Source.siteProperty((String)"ignored"));
        Assert.assertFalse((boolean)PropertyKey.fromString((String)fakeKeyName).isBuiltIn());
        PropertyKey fakeExtensionKey = new PropertyKey.Builder(fakeKeyName).build();
        Assert.assertEquals((Object)"value", (Object)this.mConfiguration.get(fakeExtensionKey));
        Assert.assertTrue((boolean)PropertyKey.fromString((String)fakeKeyName).isBuiltIn());
    }

    @Test
    public void findPropertiesFileClasspath() throws Exception {
        try (Closeable p = new SystemPropertyRule(PropertyKey.TEST_MODE.toString(), "false").toResource();){
            File dir = AlluxioTestDirectory.createTemporaryDirectory("findPropertiesFileClasspath");
            CommonUtils.classLoadURL(dir.getCanonicalPath());
            File props = new File(dir, "alluxio-site.properties");
            try (BufferedWriter writer = Files.newBufferedWriter(props.toPath(), new OpenOption[0]);){
                writer.write(String.format("%s=%s", PropertyKey.MASTER_HOSTNAME, "test_hostname"));
            }
            this.resetConf();
            Assert.assertEquals((Object)"test_hostname", (Object)this.mConfiguration.get(PropertyKey.MASTER_HOSTNAME));
            Assert.assertEquals((Object)Source.siteProperty((String)props.getCanonicalPath()), (Object)this.mConfiguration.getSource(PropertyKey.MASTER_HOSTNAME));
            props.delete();
        }
    }

    @Test
    public void noPropertiesAnywhere() throws Exception {
        try (Closeable p = new SystemPropertyRule(PropertyKey.TEST_MODE.toString(), "false").toResource();){
            this.mConfiguration.unset(PropertyKey.SITE_CONF_DIR);
            this.resetConf();
            Assert.assertEquals((Object)"0.0.0.0", (Object)this.mConfiguration.get(PropertyKey.PROXY_WEB_BIND_HOST));
        }
    }

    @Test
    public void initConfWithExtenstionProperty() throws Exception {
        try (Closeable p = new SystemPropertyRule("alluxio.master.journal.ufs.option.fs.obs.endpoint", "foo").toResource();){
            this.resetConf();
            Assert.assertEquals((Object)"foo", (Object)this.mConfiguration.get(PropertyKey.Template.MASTER_JOURNAL_UFS_OPTION_PROPERTY.format(new Object[]{"fs.obs.endpoint"})));
        }
    }

    @Test
    public void validateDefaultConfiguration() {
        this.mConfiguration.validate();
    }

    @Test
    public void removedKeyThrowsException() {
        try {
            this.mConfiguration.set(PropertyKey.fromString((String)"alluxio.test.removed.key"), (Object)"true");
            this.mConfiguration.validate();
            Assert.fail((String)"Should have thrown a runtime exception when validating with a removed key");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.format("%s is no longer a valid property", "alluxio.test.removed.key")));
        }
        this.mConfiguration = ConfigurationTestUtils.defaults();
        try {
            this.mConfiguration.set(PropertyKey.fromString((String)"alluxio.test.removed.key"), (Object)"true");
            this.mConfiguration.validate();
            Assert.fail((String)"Should have thrown a runtime exception when validating with a removed key");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.format("%s is no longer a valid property", "alluxio.test.removed.key")));
        }
    }

    @Test
    public void testDeprecatedKey() {
        this.mConfiguration.set(PropertyKey.TEST_DEPRECATED_KEY, (Object)"true");
        this.mConfiguration.validate();
        String logString = String.format("%s is deprecated", PropertyKey.TEST_DEPRECATED_KEY);
        Assert.assertTrue((boolean)this.mLogger.wasLogged(logString));
        Assert.assertEquals((long)1L, (long)this.mLogger.logCount(logString));
    }

    @Test
    public void testDeprecatedKeysNotLogged() {
        this.mConfiguration.validate();
        Assert.assertFalse((boolean)this.mLogger.wasLogged(" is deprecated"));
    }

    @Test
    public void unknownTieredStorageAlias() throws Exception {
        for (String alias : Arrays.asList("mem", "ssd", "hdd", "unknown")) {
            try {
                Closeable p = new SystemPropertyRule("alluxio.worker.tieredstore.level0.alias", alias).toResource();
                Throwable throwable = null;
                try {
                    this.resetConf();
                    this.mConfiguration.validate();
                    Assert.fail((String)"Should have thrown a runtime exception when using an unknown tier alias");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (p == null) continue;
                    if (throwable != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    p.close();
                }
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains(String.format("Alias \"%s\" on tier 0 on worker (configured by %s) is not found in global tiered", alias, PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{0}))));
            }
        }
    }

    @Test
    public void wrongTieredStorageLevel() throws Exception {
        try (Closeable p = new SystemPropertyRule((Map<String, String>)ImmutableMap.of((Object)"alluxio.master.tieredstore.global.levels", (Object)"1", (Object)"alluxio.worker.tieredstore.levels", (Object)"2")).toResource();){
            this.resetConf();
            this.mConfiguration.validate();
            Assert.fail((String)"Should have thrown a runtime exception when setting an unknown tier level");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.format("%s tiers on worker (configured by %s), larger than global %s tiers (configured by %s) ", 2, PropertyKey.WORKER_TIERED_STORE_LEVELS, 1, PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVELS)));
        }
    }

    private static enum TestEnum {
        VALUE;

    }
}

