/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.AlluxioProperties;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlluxioPropertiesTest {
    private AlluxioProperties mProperties = new AlluxioProperties();
    private PropertyKey mKeyWithValue;
    private PropertyKey mKeyWithoutValue;

    @Before
    public void before() {
        this.mKeyWithValue = new PropertyKey.Builder("key.with.value").setDefaultValue((Object)"value").build();
        this.mKeyWithoutValue = new PropertyKey.Builder("key.without.value").build();
    }

    @After
    public void after() {
        PropertyKey.unregister((PropertyKey)this.mKeyWithValue);
        PropertyKey.unregister((PropertyKey)this.mKeyWithoutValue);
    }

    @Test
    public void get() {
        Assert.assertEquals((Object)"value", (Object)this.mProperties.get(this.mKeyWithValue));
        Assert.assertEquals(null, (Object)this.mProperties.get(this.mKeyWithoutValue));
        this.mProperties.put(this.mKeyWithoutValue, "newValue1", Source.RUNTIME);
        Assert.assertEquals((Object)"newValue1", (Object)this.mProperties.get(this.mKeyWithoutValue));
    }

    @Test
    public void clear() {
        this.mProperties.put(this.mKeyWithValue, "ignored1", Source.RUNTIME);
        this.mProperties.put(this.mKeyWithoutValue, "ignored2", Source.RUNTIME);
        this.mProperties.clear();
        Assert.assertEquals(null, (Object)this.mProperties.get(this.mKeyWithoutValue));
        Assert.assertEquals((Object)"value", (Object)this.mProperties.get(this.mKeyWithValue));
    }

    @Test
    public void put() {
        this.mProperties.put(this.mKeyWithValue, "value1", Source.SYSTEM_PROPERTY);
        this.mProperties.put(this.mKeyWithoutValue, "value2", Source.SYSTEM_PROPERTY);
        Assert.assertEquals((Object)"value1", (Object)this.mProperties.get(this.mKeyWithValue));
        Assert.assertEquals((Object)"value2", (Object)this.mProperties.get(this.mKeyWithoutValue));
        this.mProperties.put(this.mKeyWithValue, "valueLowerPriority", Source.siteProperty((String)""));
        Assert.assertEquals((Object)"value1", (Object)this.mProperties.get(this.mKeyWithValue));
        this.mProperties.put(this.mKeyWithValue, "valueSamePriority", Source.SYSTEM_PROPERTY);
        Assert.assertEquals((Object)"valueSamePriority", (Object)this.mProperties.get(this.mKeyWithValue));
        this.mProperties.put(this.mKeyWithValue, "valueHigherPriority", Source.RUNTIME);
        Assert.assertEquals((Object)"valueHigherPriority", (Object)this.mProperties.get(this.mKeyWithValue));
    }

    @Test
    public void remove() {
        this.mProperties.remove(this.mKeyWithValue);
        Assert.assertEquals((Object)this.mKeyWithValue.getDefaultValue(), (Object)this.mProperties.get(this.mKeyWithValue));
        Assert.assertEquals((Object)Source.DEFAULT, (Object)this.mProperties.getSource(this.mKeyWithValue));
    }

    @Test
    public void isSet() {
        Assert.assertTrue((boolean)this.mProperties.isSet(this.mKeyWithValue));
        Assert.assertFalse((boolean)this.mProperties.isSet(this.mKeyWithoutValue));
        this.mProperties.remove(this.mKeyWithValue);
        this.mProperties.put(this.mKeyWithoutValue, "value", Source.RUNTIME);
        Assert.assertTrue((boolean)this.mProperties.isSet(this.mKeyWithValue));
        Assert.assertTrue((boolean)this.mProperties.isSet(this.mKeyWithoutValue));
    }

    @Test
    public void entrySet() {
        Set expected = PropertyKey.defaultKeys().stream().map(key -> Maps.immutableEntry((Object)key, (Object)key.getDefaultValue())).collect(Collectors.toSet());
        Assert.assertThat((Object)this.mProperties.entrySet(), (Matcher)Is.is(expected));
        this.mProperties.put(this.mKeyWithValue, "value", Source.RUNTIME);
        expected.add(Maps.immutableEntry((Object)this.mKeyWithValue, (Object)"value"));
        Assert.assertThat((Object)this.mProperties.entrySet(), (Matcher)Is.is(expected));
    }

    @Test
    public void keySet() {
        HashSet<PropertyKey> expected = new HashSet<PropertyKey>(PropertyKey.defaultKeys());
        Assert.assertThat((Object)this.mProperties.keySet(), (Matcher)Is.is(expected));
        PropertyKey newKey = new PropertyKey.Builder("keySetNew").build();
        this.mProperties.put(newKey, "value", Source.RUNTIME);
        expected.add(newKey);
        Assert.assertThat((Object)this.mProperties.keySet(), (Matcher)Is.is(expected));
    }

    @Test
    public void forEach() {
        HashSet<PropertyKey> expected = new HashSet<PropertyKey>(PropertyKey.defaultKeys());
        HashSet actual = Sets.newHashSet();
        this.mProperties.forEach((key, value) -> actual.add(key));
        Assert.assertThat((Object)actual, (Matcher)Is.is(expected));
        PropertyKey newKey = new PropertyKey.Builder("forEachNew").build();
        this.mProperties.put(newKey, "value", Source.RUNTIME);
        HashSet actual2 = Sets.newHashSet();
        this.mProperties.forEach((key, value) -> actual2.add(key));
        expected.add(newKey);
        Assert.assertThat((Object)actual2, (Matcher)Is.is(expected));
    }

    @Test
    public void setGetSource() {
        this.mProperties.put(this.mKeyWithValue, "valueIgnored", Source.RUNTIME);
        Assert.assertEquals((Object)Source.RUNTIME, (Object)this.mProperties.getSource(this.mKeyWithValue));
        Assert.assertEquals((Object)Source.DEFAULT, (Object)this.mProperties.getSource(this.mKeyWithoutValue));
    }

    @Test
    public void merge() {
        PropertyKey newKey = new PropertyKey.Builder("mergeNew").setDefaultValue((Object)"value3").build();
        Properties sysProp = new Properties();
        sysProp.put(this.mKeyWithValue, "value1");
        sysProp.put(this.mKeyWithoutValue, "value2");
        this.mProperties.merge((Map)sysProp, Source.SYSTEM_PROPERTY);
        Assert.assertEquals((Object)Source.SYSTEM_PROPERTY, (Object)this.mProperties.getSource(this.mKeyWithValue));
        Assert.assertEquals((Object)Source.SYSTEM_PROPERTY, (Object)this.mProperties.getSource(this.mKeyWithoutValue));
        Assert.assertEquals((Object)Source.DEFAULT, (Object)this.mProperties.getSource(newKey));
        Assert.assertEquals((Object)"value1", (Object)this.mProperties.get(this.mKeyWithValue));
        Assert.assertEquals((Object)"value2", (Object)this.mProperties.get(this.mKeyWithoutValue));
        Assert.assertEquals((Object)"value3", (Object)this.mProperties.get(newKey));
    }

    @Test
    public void hash() {
        String hash0 = this.mProperties.hash();
        this.mProperties.set(this.mKeyWithValue, "new value");
        String hash1 = this.mProperties.hash();
        Assert.assertNotEquals((Object)hash0, (Object)hash1);
        this.mProperties.remove(this.mKeyWithValue);
        String hash2 = this.mProperties.hash();
        Assert.assertEquals((Object)hash0, (Object)hash2);
        this.mProperties.set(this.mKeyWithValue, "new value");
        String hash3 = this.mProperties.hash();
        Assert.assertEquals((Object)hash1, (Object)hash3);
        this.mProperties.set(this.mKeyWithValue, "updated new value");
        String hash4 = this.mProperties.hash();
        Assert.assertNotEquals((Object)hash0, (Object)hash4);
        Assert.assertNotEquals((Object)hash1, (Object)hash4);
        Assert.assertNotEquals((Object)hash2, (Object)hash4);
        Assert.assertNotEquals((Object)hash3, (Object)hash4);
        this.mProperties.set(this.mKeyWithoutValue, "value");
        String hash5 = this.mProperties.hash();
        Assert.assertNotEquals((Object)hash0, (Object)hash5);
        Assert.assertNotEquals((Object)hash1, (Object)hash5);
        Assert.assertNotEquals((Object)hash2, (Object)hash5);
        Assert.assertNotEquals((Object)hash3, (Object)hash5);
        Assert.assertNotEquals((Object)hash4, (Object)hash5);
    }
}

