/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.concurrent.CountingLatch;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CountingLatchTest {
    private static final long SLEEP_MILLIS = 1000L;
    private static final long STILL_BLOCKED = -1L;
    private CountingLatch mLatch;
    @Rule
    public ExpectedException mExpectedException = ExpectedException.none();

    @Before
    public void before() {
        this.mLatch = new CountingLatch();
    }

    @Test
    public void noAwait() throws Exception {
        int i;
        int N = 10;
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.mLatch.getState());
            this.mLatch.inc();
            Assert.assertEquals((long)1L, (long)this.mLatch.getState());
            this.mLatch.dec();
            Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)this.mLatch.getState());
            this.mLatch.inc();
        }
        for (i = 0; i < 10; ++i) {
            this.mLatch.dec();
            Assert.assertEquals((long)(9 - i), (long)this.mLatch.getState());
        }
    }

    @Test
    public void blockAndUnblockInc() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        this.mLatch.await();
        Assert.assertEquals((long)-1L, (long)this.mLatch.getState());
        BlockingThread inc = new BlockingThread(() -> {
            try {
                this.mLatch.inc();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        inc.start();
        Thread.sleep(1000L);
        this.mLatch.release();
        inc.join();
        Assert.assertTrue((String)String.format("BlockedTimeMillis: %s", inc.getBlockedTimeMillis()), (inc.getBlockedTimeMillis() >= 1000L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.mLatch.getState());
    }

    @Test
    public void unblockMultipleInc() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        this.mLatch.await();
        Assert.assertEquals((long)-1L, (long)this.mLatch.getState());
        ArrayList<BlockingThread> incThreads = new ArrayList<BlockingThread>();
        int numThreads = 10;
        for (int i = 0; i < 10; ++i) {
            incThreads.add(new BlockingThread(() -> {
                try {
                    this.mLatch.inc();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        for (BlockingThread t : incThreads) {
            t.start();
        }
        Thread.sleep(1000L);
        this.mLatch.release();
        for (BlockingThread t : incThreads) {
            t.join();
            Assert.assertTrue((String)String.format("BlockedTimeMillis: %s", t.getBlockedTimeMillis()), (t.getBlockedTimeMillis() >= 1000L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)10L, (long)this.mLatch.getState());
    }

    @Test
    public void await() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        this.mLatch.inc();
        Assert.assertEquals((long)1L, (long)this.mLatch.getState());
        this.mLatch.inc();
        Assert.assertEquals((long)2L, (long)this.mLatch.getState());
        BlockingThread await = new BlockingThread(() -> ((CountingLatch)this.mLatch).await());
        await.start();
        Assert.assertEquals((long)-1L, (long)await.getBlockedTimeMillis());
        Thread.sleep(1000L);
        this.mLatch.dec();
        Assert.assertEquals((long)1L, (long)this.mLatch.getState());
        Assert.assertEquals((long)-1L, (long)await.getBlockedTimeMillis());
        Thread.sleep(1000L);
        this.mLatch.dec();
        Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        await.join();
        Assert.assertTrue((String)String.format("BlockedTimeMillis: %s", await.getBlockedTimeMillis()), (await.getBlockedTimeMillis() >= 2000L ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)this.mLatch.getState());
    }

    @Test
    public void blockedAwait() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.mLatch.getState());
        this.mLatch.inc();
        Assert.assertEquals((long)1L, (long)this.mLatch.getState());
        BlockingThread await = new BlockingThread(() -> ((CountingLatch)this.mLatch).await());
        await.start();
        int incAfterAwait = 10;
        for (i = 0; i < incAfterAwait; ++i) {
            this.mLatch.inc();
            Assert.assertEquals((long)(i + 2), (long)this.mLatch.getState());
        }
        for (i = 0; i < incAfterAwait; ++i) {
            this.mLatch.dec();
            Assert.assertEquals((long)(incAfterAwait - i), (long)this.mLatch.getState());
        }
        this.mLatch.dec();
        await.join();
        Assert.assertEquals((long)-1L, (long)this.mLatch.getState());
    }

    @Test
    public void decWithoutInc() throws Exception {
        this.mLatch.inc();
        this.mLatch.dec();
        this.mExpectedException.expect(Error.class);
        this.mLatch.dec();
    }

    @Test
    public void releaseWithoutAwait() {
        this.mLatch.await();
        this.mLatch.release();
        this.mExpectedException.expect(Error.class);
        this.mLatch.release();
    }

    @Test
    public void interruptInc() throws Exception {
        this.mLatch.await();
        Thread inc = new Thread(() -> {
            try {
                this.mLatch.inc();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        inc.start();
        inc.join(1000L);
        Assert.assertEquals((Object)((Object)Thread.State.WAITING), (Object)((Object)inc.getState()));
        inc.interrupt();
        inc.join();
    }

    private static class BlockingThread
    extends Thread {
        private volatile long mBlockedTimeMillis = -1L;
        private final Runnable mRunnable;
        private final long mStart;

        public BlockingThread(Runnable runnable) {
            this.mRunnable = runnable;
            this.mStart = System.currentTimeMillis();
        }

        @Override
        public void run() {
            this.mRunnable.run();
            this.mBlockedTimeMillis = System.currentTimeMillis() - this.mStart;
        }

        public long getBlockedTimeMillis() {
            return this.mBlockedTimeMillis;
        }
    }
}

