/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.LockPool;
import alluxio.concurrent.LockMode;
import alluxio.resource.LockResource;
import alluxio.util.CommonUtils;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LockPoolTest {
    private LockPool<Integer> mPool;
    private static final int LOW_WATERMARK = 8;
    private static final int HIGH_WATERMARK = 16;

    @Before
    public void before() {
        this.mPool = new LockPool(k -> new ReentrantReadWriteLock(), 2, 8, 16, 4);
    }

    @After
    public void after() throws Exception {
        this.mPool.close();
    }

    @Test(timeout=10000L)
    public void insertValueTest() throws Exception {
        Object resource;
        for (int key = 0; key < 16; ++key) {
            Assert.assertEquals((long)key, (long)this.mPool.size());
            resource = this.mPool.get((Object)key, LockMode.READ);
            Throwable throwable = null;
            try {
                Assert.assertTrue((boolean)this.mPool.containsKey((Object)key));
                Assert.assertEquals((long)(key + 1), (long)this.mPool.size());
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resource != null) {
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resource.close();
                    }
                }
            }
        }
        LockResource r = this.mPool.get((Object)16, LockMode.READ);
        resource = null;
        try {
            Assert.assertTrue((boolean)this.mPool.containsKey((Object)16));
            CommonUtils.waitFor((String)"Pool size to go below low watermark", () -> this.mPool.size() <= 8);
            Assert.assertEquals((long)8L, (long)this.mPool.size());
        }
        catch (Throwable throwable) {
            resource = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (resource != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)resource).addSuppressed(throwable);
                    }
                } else {
                    r.close();
                }
            }
        }
        for (int newLock = 1; newLock <= 8; ++newLock) {
            int key = 16 + newLock;
            try (LockResource resource2 = this.mPool.get((Object)key, LockMode.READ);){
                Assert.assertTrue((boolean)this.mPool.containsKey((Object)key));
                Assert.assertEquals((long)(8 + newLock), (long)this.mPool.size());
                continue;
            }
        }
        r = this.mPool.get((Object)32, LockMode.READ);
        Throwable throwable = null;
        try {
            Assert.assertTrue((boolean)this.mPool.containsKey((Object)32));
            CommonUtils.waitFor((String)"Pool size to go below low watermark", () -> this.mPool.size() <= 8);
            Assert.assertEquals((long)8L, (long)this.mPool.size());
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (r != null) {
                if (throwable != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    r.close();
                }
            }
        }
    }

    private Thread getKeys(int low, int high) {
        Thread t = new Thread(() -> {
            for (int i = low; i < high; ++i) {
                LockResource resource = this.mPool.get((Object)i, LockMode.READ);
                Throwable throwable = null;
                if (resource == null) continue;
                if (throwable != null) {
                    try {
                        resource.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                resource.close();
            }
        });
        t.start();
        return t;
    }

    @Test(timeout=1000L)
    public void parallelInsertTest() throws Exception {
        Thread t1 = this.getKeys(0, 16);
        Thread t2 = this.getKeys(0, 16);
        t1.join();
        t2.join();
        Assert.assertEquals((long)16L, (long)this.mPool.size());
        for (int key = 0; key < 16; ++key) {
            Assert.assertTrue((boolean)this.mPool.containsKey((Object)key));
        }
        Thread t3 = this.getKeys(16, 17);
        t3.join();
        CommonUtils.waitFor((String)"Pool size to go below low watermark", () -> this.mPool.size() <= 8);
        Assert.assertEquals((long)8L, (long)this.mPool.size());
        int newStartKey = 17;
        int newEndKey = newStartKey + 16 - 8;
        Thread t4 = this.getKeys(newStartKey, newEndKey);
        Thread t5 = this.getKeys(newStartKey, newEndKey);
        t4.join();
        t5.join();
        Assert.assertEquals((long)16L, (long)this.mPool.size());
        for (int key = newStartKey; key < newEndKey; ++key) {
            Assert.assertTrue((String)Integer.toString(key), (boolean)this.mPool.containsKey((Object)key));
        }
    }

    @Test(timeout=1000L)
    public void referencedLockTest() {
        LockResource lock0 = this.mPool.get((Object)0, LockMode.READ);
        LockResource lock1 = this.mPool.get((Object)50, LockMode.READ);
        LockResource lock2 = this.mPool.get((Object)100, LockMode.READ);
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 100; ++i) {
                this.mPool.get((Object)i, LockMode.READ).close();
            }
        }
        Assert.assertTrue((boolean)lock0.hasSameLock(this.mPool.get((Object)0, LockMode.READ)));
        Assert.assertTrue((boolean)lock1.hasSameLock(this.mPool.get((Object)50, LockMode.READ)));
        Assert.assertTrue((boolean)lock2.hasSameLock(this.mPool.get((Object)100, LockMode.READ)));
    }
}

