/*
 * Decompiled with CFR 0.152.
 */
package alluxio.clock;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;

public final class ManualClock
extends Clock {
    private long mTimeMs;

    public ManualClock() {
        this(System.currentTimeMillis());
    }

    public ManualClock(long time) {
        this.mTimeMs = time;
    }

    public synchronized void setTimeMs(long timeMs) {
        this.mTimeMs = timeMs;
    }

    public synchronized void addTimeMs(long timeMs) {
        this.mTimeMs += timeMs;
    }

    public synchronized void addTime(Duration time) {
        this.mTimeMs += time.toMillis();
    }

    @Override
    public synchronized long millis() {
        return this.mTimeMs;
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new UnsupportedOperationException("ManualClock only uses UTC");
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.mTimeMs);
    }
}

