/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.URIStatus;
import alluxio.wire.FileInfo;
import alluxio.wire.FileInfoTest;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class URIStatusTest {
    @Test
    public void constructor() {
        try {
            new URIStatus(null);
            Assert.fail((String)"Cannot create a URIStatus from a null FileInfo");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create a URIStatus from a null FileInfo"));
        }
    }

    @Test
    public void fields() {
        FileInfo fileInfo = FileInfoTest.createRandom();
        URIStatus uriStatus = new URIStatus(fileInfo);
        Assert.assertEquals((Object)uriStatus.getBlockIds(), (Object)fileInfo.getBlockIds());
        Assert.assertEquals((long)uriStatus.getBlockSizeBytes(), (long)fileInfo.getBlockSizeBytes());
        Assert.assertEquals((long)uriStatus.getCreationTimeMs(), (long)fileInfo.getCreationTimeMs());
        Assert.assertEquals((long)uriStatus.getFileId(), (long)fileInfo.getFileId());
        Assert.assertEquals((Object)uriStatus.getGroup(), (Object)fileInfo.getGroup());
        Assert.assertEquals((long)uriStatus.getInMemoryPercentage(), (long)fileInfo.getInMemoryPercentage());
        Assert.assertEquals((long)uriStatus.getLastModificationTimeMs(), (long)fileInfo.getLastModificationTimeMs());
        Assert.assertEquals((long)uriStatus.getLength(), (long)fileInfo.getLength());
        Assert.assertEquals((Object)uriStatus.getName(), (Object)fileInfo.getName());
        Assert.assertEquals((Object)uriStatus.getPath(), (Object)fileInfo.getPath());
        Assert.assertEquals((long)uriStatus.getMode(), (long)fileInfo.getMode());
        Assert.assertEquals((Object)uriStatus.getPersistenceState(), (Object)fileInfo.getPersistenceState());
        Assert.assertEquals((long)uriStatus.getTtl(), (long)fileInfo.getTtl());
        Assert.assertEquals((Object)uriStatus.getTtlAction(), (Object)fileInfo.getTtlAction());
        Assert.assertEquals((Object)uriStatus.getUfsPath(), (Object)fileInfo.getUfsPath());
        Assert.assertEquals((Object)uriStatus.getOwner(), (Object)fileInfo.getOwner());
        Assert.assertEquals((Object)uriStatus.isCacheable(), (Object)fileInfo.isCacheable());
        Assert.assertEquals((Object)uriStatus.isCompleted(), (Object)fileInfo.isCompleted());
        Assert.assertEquals((Object)uriStatus.isFolder(), (Object)fileInfo.isFolder());
        Assert.assertEquals((Object)uriStatus.isPersisted(), (Object)fileInfo.isPersisted());
        Assert.assertEquals((Object)uriStatus.isPinned(), (Object)fileInfo.isPinned());
        Assert.assertEquals((Object)uriStatus.isMountPoint(), (Object)fileInfo.isMountPoint());
        Assert.assertEquals((Object)uriStatus.getFileBlockInfos(), (Object)fileInfo.getFileBlockInfos());
        Assert.assertEquals((Object)uriStatus.toString(), (Object)fileInfo.toString());
        Assert.assertEquals((long)uriStatus.getXAttr().size(), (long)fileInfo.getXAttr().size());
        for (Map.Entry entry : uriStatus.getXAttr().entrySet()) {
            Assert.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])((byte[])fileInfo.getXAttr().get(entry.getKey())));
        }
    }

    @Test
    public void testEquals() throws Exception {
        FileInfo fileInfo = FileInfoTest.createRandom();
        URIStatus uriStatus1 = new URIStatus(fileInfo);
        URIStatus uriStatus2 = new URIStatus(fileInfo);
        Assert.assertTrue((boolean)uriStatus1.equals((Object)uriStatus2));
        Assert.assertEquals((long)uriStatus1.hashCode(), (long)uriStatus2.hashCode());
    }
}

