/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class CommandTest {
    private static final String COMMAND_NAME = "TestCommand";
    @Rule
    public ExpectedException mExpectedException = ExpectedException.none();

    @Test
    public void expectedNumArgs() throws Exception {
        TestCommand cmd = new TestCommand();
        CommandLine commandLine = cmd.parseAndValidateArgs(new String[]{"arg1"});
        Assert.assertEquals((long)1L, (long)commandLine.getArgs().length);
    }

    @Test
    public void unexpectedNumArgs() throws Exception {
        TestCommand cmd = new TestCommand();
        this.mExpectedException.expect(InvalidArgumentException.class);
        this.mExpectedException.expectMessage(ExceptionMessage.INVALID_ARGS_NUM.getMessage(new Object[]{cmd.getCommandName(), 1, 2}));
        cmd.parseAndValidateArgs(new String[]{"arg1", "arg2"});
    }

    private final class TestCommand
    implements Command {
        public String getCommandName() {
            return CommandTest.COMMAND_NAME;
        }

        public String getDescription() {
            return "Description";
        }

        public void validateArgs(CommandLine cl) throws InvalidArgumentException {
            CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
        }

        public String getUsage() {
            return "usage";
        }

        public int run(CommandLine cl) {
            return 0;
        }
    }
}

