/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.ConfigurationTestUtils;
import alluxio.SystemOutRule;
import alluxio.cli.AbstractShell;
import alluxio.cli.Command;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public final class AbstractShellTest {
    private static final String SHELL_NAME = "TestShell";
    public ByteArrayOutputStream mOutput = new ByteArrayOutputStream();
    @Rule
    public SystemOutRule mSystemOutRule = new SystemOutRule(this.mOutput);
    @Rule
    public ExpectedException mExpectedException = ExpectedException.none();

    @Test
    public void commandExists() throws Exception {
        TestShell shell = new TestShell();
        Assert.assertEquals((long)0L, (long)shell.run(new String[]{"cmd"}));
    }

    @Test
    public void stableAliasNoWarning() throws Exception {
        TestShell shell = new TestShell();
        Assert.assertEquals((long)0L, (long)shell.run(new String[]{"stableAlias"}));
        Assert.assertFalse((boolean)this.mOutput.toString().contains("WARNING: stableAlias"));
    }

    @Test
    public void commandAliasExists() throws Exception {
        TestShell shell = new TestShell();
        Assert.assertEquals((long)0L, (long)shell.run(new String[]{"cmdAlias"}));
        String warningMsg = "WARNING: cmdAlias is not a stable CLI command. It may be removed in the future. Use with caution in scripts. You may use 'cmd -O' instead.";
        String output = this.mOutput.toString();
        Assert.assertTrue((String)String.format("Output should contain proper warning.\nActual:   %s\nExpected: %s", output, warningMsg), (boolean)output.contains(warningMsg));
    }

    @Test
    public void commandDoesNotExist() throws Exception {
        TestShell shell = new TestShell();
        Assert.assertTrue((shell.run(new String[]{"cmdNotExist"}) < 0 ? 1 : 0) != 0);
    }

    private final class TestShell
    extends AbstractShell {
        public TestShell() {
            super((Map)ImmutableMap.builder().put((Object)"cmdAlias", (Object)new String[]{"cmd", "-O"}).put((Object)"stableAlias", (Object)new String[]{"cmd", "-O"}).build(), (Set)ImmutableSet.builder().add((Object)"cmdAlias").build(), ConfigurationTestUtils.defaults());
        }

        protected String getShellName() {
            return AbstractShellTest.SHELL_NAME;
        }

        protected Map<String, Command> loadCommands() {
            Command cmd = (Command)Mockito.mock(Command.class);
            try {
                Mockito.when((Object)cmd.run((CommandLine)Mockito.any(CommandLine.class))).thenReturn((Object)0);
                Mockito.when((Object)cmd.parseAndValidateArgs((String[])Mockito.any(String[].class))).thenReturn(Mockito.mock(CommandLine.class));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ImmutableMap.builder().put((Object)"cmd", (Object)cmd).build();
        }
    }
}

