/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractResourceRule;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Before;

public class TestLoggerRule
extends AbstractResourceRule {
    private TestAppender mAppender;

    @Before
    public void before() {
        this.mAppender = new TestAppender();
        Logger.getRootLogger().addAppender((Appender)this.mAppender);
    }

    @After
    public void after() {
        Logger.getRootLogger().removeAppender((Appender)this.mAppender);
    }

    public boolean wasLogged(String pattern) {
        return this.mAppender.wasLogged(Pattern.compile(".*" + pattern + ".*"));
    }

    public boolean wasLoggedWithLevel(String pattern, Level level) {
        return this.mAppender.wasLoggedWithLevel(Pattern.compile(".*" + pattern + ".*"), level);
    }

    public int logCount(String pattern) {
        return this.mAppender.logCount(Pattern.compile(".*" + pattern + ".*"));
    }

    public void dumpLogs(PrintStream stream) {
        for (LoggingEvent event : this.mAppender.mEvents) {
            stream.println(event.getRenderedMessage());
        }
    }

    public class TestAppender
    extends AppenderSkeleton {
        @GuardedBy(value="this")
        private final List<LoggingEvent> mEvents = new ArrayList<LoggingEvent>();

        public void close() {
        }

        public synchronized boolean wasLogged(Pattern pattern) {
            for (LoggingEvent e : this.mEvents) {
                if (!pattern.matcher(e.getRenderedMessage()).matches()) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean wasLoggedWithLevel(Pattern pattern, Level level) {
            for (LoggingEvent e : this.mEvents) {
                if (!e.getLevel().equals((Object)level) || !pattern.matcher(e.getRenderedMessage()).matches()) continue;
                return true;
            }
            return false;
        }

        public synchronized int logCount(Pattern pattern) {
            int logCount = 0;
            for (LoggingEvent e : this.mEvents) {
                if (!pattern.matcher(e.getRenderedMessage()).matches()) continue;
                ++logCount;
            }
            return logCount;
        }

        public boolean requiresLayout() {
            return false;
        }

        protected synchronized void append(LoggingEvent event) {
            this.mEvents.add(event);
        }
    }
}

