/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractResourceRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SystemPropertyRule
extends AbstractResourceRule {
    private final Map<String, String> mProperties;
    private final Map<String, String> mOriginalProperties = new HashMap<String, String>();
    private final Set<String> mOriginalNullProperties = new HashSet<String>();

    public SystemPropertyRule(Map<String, String> keyValuePairs) {
        this.mProperties = keyValuePairs;
    }

    public SystemPropertyRule(String propertyName, String value) {
        this.mProperties = new HashMap<String, String>();
        this.mProperties.put(propertyName, value);
    }

    public void before() {
        for (Map.Entry<String, String> entry : this.mProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String prevValue = System.getProperty(key);
            if (prevValue == null) {
                this.mOriginalNullProperties.add(key);
            } else {
                this.mOriginalProperties.put(key, prevValue);
            }
            if (value == null) {
                System.clearProperty(key);
                continue;
            }
            System.setProperty(key, value);
        }
    }

    public void after() {
        for (Map.Entry<String, String> entry : this.mOriginalProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        for (String key : this.mOriginalNullProperties) {
            System.clearProperty(key);
        }
    }
}

