/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractResourceRule;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RedirectOutputRule
extends AbstractResourceRule {
    private final OutputStream mOutputStream;
    private final Consumer<PrintStream> mRedirector;
    private PrintStream mInputStream;
    private PrintStream mNewOutput;
    private PrintStream mOldOutput;

    public RedirectOutputRule(PrintStream inputStream, OutputStream outputStream, Consumer<PrintStream> redirector) {
        this.mInputStream = inputStream;
        this.mOutputStream = outputStream;
        this.mRedirector = redirector;
    }

    protected void before() throws Exception {
        this.mNewOutput = new PrintStream(this.mOutputStream);
        this.mOldOutput = this.mInputStream;
        this.mRedirector.accept(this.mNewOutput);
    }

    protected void after() {
        this.mRedirector.accept(this.mOldOutput);
    }
}

