/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ConfigurationUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ConfigurationTestUtils {
    public static InstancedConfiguration defaults() {
        return new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    public static Map<PropertyKey, String> testConfigurationDefaults(AlluxioConfiguration alluxioConf, String hostname, String workDirectory) {
        HashMap<PropertyKey, String> conf = new HashMap<PropertyKey, String>();
        conf.put(PropertyKey.MASTER_HOSTNAME, hostname);
        conf.put(PropertyKey.WORKER_BIND_HOST, hostname);
        conf.put(PropertyKey.WORKER_WEB_BIND_HOST, hostname);
        conf.put(PropertyKey.MASTER_BIND_HOST, hostname);
        conf.put(PropertyKey.MASTER_WEB_BIND_HOST, hostname);
        conf.put(PropertyKey.WORK_DIR, workDirectory);
        conf.put(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{0}), "MEM");
        String ramdiskPath = PathUtils.concatPath((Object)workDirectory, (Object)"ramdisk");
        conf.put(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0}), ramdiskPath);
        int numLevel = alluxioConf.getInt(PropertyKey.WORKER_TIERED_STORE_LEVELS);
        for (int level = 1; level < numLevel; ++level) {
            PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
            String[] dirPaths = alluxioConf.get(tierLevelDirPath).split(",");
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String dirPath : dirPaths) {
                String newPath = workDirectory + dirPath;
                newPaths.add(newPath);
            }
            conf.put(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level}), Joiner.on((char)',').join(newPaths));
        }
        conf.put(PropertyKey.WORKER_REVIEWER_CLASS, "alluxio.worker.block.reviewer.AcceptingReviewer");
        conf.put(PropertyKey.MASTER_JOURNAL_TYPE, "UFS");
        conf.put(PropertyKey.MASTER_JOURNAL_FOLDER, PathUtils.concatPath((Object)workDirectory, (Object)"journal"));
        conf.put(PropertyKey.MASTER_METASTORE_DIR, PathUtils.concatPath((Object)workDirectory, (Object)"metastore"));
        conf.put(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, "1KB");
        conf.put(PropertyKey.USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES, "64");
        conf.put(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, "64");
        conf.put(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, "1sec");
        conf.put(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, "1sec");
        conf.put(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT, "5sec");
        conf.put(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_GRACEFUL_TIMEOUT, "3sec");
        conf.put(PropertyKey.NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT, "10sec");
        conf.put(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, "50ms");
        conf.put(PropertyKey.MASTER_JOURNAL_TAILER_SLEEP_TIME_MS, "10ms");
        conf.put(PropertyKey.USER_RPC_RETRY_MAX_DURATION, "2s");
        conf.put(PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS, "200");
        conf.put(PropertyKey.USER_RPC_RETRY_BASE_SLEEP_MS, "20");
        conf.put(PropertyKey.MASTER_WORKER_CONNECT_WAIT_TIME, "0sec");
        conf.put(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS, "250ms");
        conf.put(PropertyKey.WEB_THREADS, "1");
        conf.put(PropertyKey.WEB_RESOURCES, PathUtils.concatPath((Object)System.getProperty("user.dir"), (Object)"../webui"));
        conf.put(PropertyKey.WORKER_RAMDISK_SIZE, "100MB");
        conf.put(PropertyKey.MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL, "15ms");
        conf.put(PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS, "15ms");
        conf.put(PropertyKey.WORKER_NETWORK_NETTY_WORKER_THREADS, "2");
        conf.put(PropertyKey.WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD, "0ms");
        conf.put(PropertyKey.WORKER_NETWORK_SHUTDOWN_TIMEOUT, "0ms");
        conf.put(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{0}), "MEM");
        conf.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_ELECTION_TIMEOUT, "260ms");
        conf.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_HEARTBEAT_INTERVAL, "50ms");
        conf.put(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX.getDefaultValue());
        conf.put(PropertyKey.USER_WORKER_LIST_REFRESH_INTERVAL, "1s");
        conf.put(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, "20ms");
        conf.put(PropertyKey.MASTER_PERSISTENCE_CHECKER_INTERVAL_MS, "20ms");
        conf.put(PropertyKey.MASTER_PERSISTENCE_INITIAL_INTERVAL_MS, "20ms");
        conf.put(PropertyKey.MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS, "20ms");
        conf.put(PropertyKey.MASTER_WORKER_INFO_CACHE_REFRESH_TIME, "20ms");
        conf.put(PropertyKey.USER_BLOCK_READ_RETRY_SLEEP_MIN, "1ms");
        conf.put(PropertyKey.USER_BLOCK_READ_RETRY_SLEEP_MIN, "5ms");
        conf.put(PropertyKey.USER_BLOCK_READ_RETRY_MAX_DURATION, "10ms");
        conf.put(PropertyKey.TEST_MODE, "true");
        return conf;
    }

    private ConfigurationTestUtils() {
    }
}

