/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractResourceRule;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import java.util.HashMap;
import java.util.Map;

public final class ConfigurationRule
extends AbstractResourceRule {
    private final Map<PropertyKey, String> mKeyValuePairs;
    private final Map<PropertyKey, String> mStashedProperties = new HashMap<PropertyKey, String>();
    private final InstancedConfiguration mConfiguration;

    public ConfigurationRule(Map<PropertyKey, String> keyValuePairs, InstancedConfiguration conf) {
        this.mKeyValuePairs = keyValuePairs;
        this.mConfiguration = conf;
    }

    public ConfigurationRule(final PropertyKey key, final String value, InstancedConfiguration conf) {
        this((Map<PropertyKey, String>)new HashMap<PropertyKey, String>(){
            {
                this.put(key, value);
            }
        }, conf);
    }

    public void before() {
        for (Map.Entry<PropertyKey, String> entry : this.mKeyValuePairs.entrySet()) {
            PropertyKey key = entry.getKey();
            String value = entry.getValue();
            if (this.mConfiguration.isSet(key)) {
                this.mStashedProperties.put(key, this.mConfiguration.get(key));
            } else {
                this.mStashedProperties.put(key, null);
            }
            if (value != null) {
                this.mConfiguration.set(key, (Object)value);
                continue;
            }
            this.mConfiguration.unset(key);
        }
    }

    public void after() {
        for (Map.Entry<PropertyKey, String> entry : this.mStashedProperties.entrySet()) {
            String value = entry.getValue();
            if (value != null) {
                this.mConfiguration.set(entry.getKey(), (Object)value);
                continue;
            }
            this.mConfiguration.unset(entry.getKey());
        }
    }
}

