/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AuthenticatedUserRule;
import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.security.authentication.AuthenticatedClientUser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.model.Statement;

public final class AuthenticatedUserRuleTest {
    private static final String TESTCASE_USER = "testcase-user";
    private static final String RULE_USER = "rule-user";
    private static final String OUTSIDE_RULE_USER = "outside-rule-user";
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();
    private final Statement mStatement = new Statement(){

        public void evaluate() throws Throwable {
            Assert.assertEquals((Object)AuthenticatedUserRuleTest.RULE_USER, (Object)AuthenticatedClientUser.get((AlluxioConfiguration)AuthenticatedUserRuleTest.this.mConfiguration).getName());
            AuthenticatedClientUser.set((String)AuthenticatedUserRuleTest.TESTCASE_USER);
            Assert.assertEquals((Object)AuthenticatedUserRuleTest.TESTCASE_USER, (Object)AuthenticatedClientUser.get((AlluxioConfiguration)AuthenticatedUserRuleTest.this.mConfiguration).getName());
        }
    };

    @After
    public void after() throws Exception {
        AuthenticatedClientUser.remove();
    }

    @Test
    public void userSetBeforeRule() throws Throwable {
        AuthenticatedClientUser.set((String)OUTSIDE_RULE_USER);
        new AuthenticatedUserRule(RULE_USER, this.mConfiguration).apply(this.mStatement, null).evaluate();
        Assert.assertEquals((Object)OUTSIDE_RULE_USER, (Object)AuthenticatedClientUser.get((AlluxioConfiguration)this.mConfiguration).getName());
    }

    @Test
    public void noUserBeforeRule() throws Throwable {
        AuthenticatedClientUser.remove();
        new AuthenticatedUserRule(RULE_USER, this.mConfiguration).apply(this.mStatement, null).evaluate();
        Assert.assertEquals(null, (Object)AuthenticatedClientUser.get((AlluxioConfiguration)this.mConfiguration));
    }
}

