/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractResourceRule;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.security.User;
import alluxio.security.authentication.AuthenticatedClientUser;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AuthenticatedUserRule
extends AbstractResourceRule {
    private final String mUser;
    private User mPreviousUser;
    private final InstancedConfiguration mConfiguration;

    public AuthenticatedUserRule(String user, InstancedConfiguration conf) {
        this.mUser = user;
        this.mConfiguration = conf;
    }

    protected void before() throws Exception {
        this.mPreviousUser = AuthenticatedClientUser.get((AlluxioConfiguration)this.mConfiguration);
        AuthenticatedClientUser.set((String)this.mUser);
    }

    protected void after() {
        if (this.mPreviousUser == null) {
            AuthenticatedClientUser.remove();
        } else {
            AuthenticatedClientUser.set((String)this.mPreviousUser.getName());
        }
    }
}

