/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AlluxioURI;
import alluxio.uri.Authority;
import alluxio.uri.MultiMasterAuthority;
import alluxio.uri.NoAuthority;
import alluxio.uri.SingleMasterAuthority;
import alluxio.uri.UnknownAuthority;
import alluxio.uri.ZookeeperAuthority;
import alluxio.util.OSUtils;
import com.google.common.testing.EqualsTester;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class AlluxioURITest {
    private static final boolean WINDOWS = OSUtils.isWindows();

    @Test
    public void basicAlluxioUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://localhost:19998/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"localhost:19998", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof SingleMasterAuthority));
        SingleMasterAuthority authority = (SingleMasterAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"localhost", (Object)authority.getHost());
        Assert.assertEquals((long)19998L, (long)authority.getPort());
        Assert.assertEquals((long)2L, (long)uri.getDepth());
        Assert.assertEquals((Object)"a b c", (Object)uri.getName());
        Assert.assertEquals((Object)"alluxio://localhost:19998/xy z", (Object)uri.getParent().toString());
        Assert.assertEquals((Object)"alluxio://localhost:19998/", (Object)uri.getParent().getParent().toString());
        Assert.assertEquals((Object)"/xy z/a b c", (Object)uri.getPath());
        Assert.assertEquals((Object)"alluxio", (Object)uri.getScheme());
        Assert.assertTrue((boolean)uri.hasScheme());
        Assert.assertTrue((boolean)uri.isAbsolute());
        Assert.assertTrue((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"alluxio://localhost:19998/xy z/a b c/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"alluxio://localhost:19998/xy z/a b c/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"alluxio://localhost:19998/xy z/a b c", (Object)uri.toString());
    }

    @Test
    public void basicHdfsUri() {
        AlluxioURI uri = new AlluxioURI("hdfs://localhost:8020/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"localhost:8020", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof SingleMasterAuthority));
        SingleMasterAuthority authority = (SingleMasterAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"localhost", (Object)authority.getHost());
        Assert.assertEquals((long)8020L, (long)authority.getPort());
        Assert.assertEquals((long)2L, (long)uri.getDepth());
        Assert.assertEquals((Object)"a b c", (Object)uri.getName());
        Assert.assertEquals((Object)"hdfs://localhost:8020/xy z", (Object)uri.getParent().toString());
        Assert.assertEquals((Object)"hdfs://localhost:8020/", (Object)uri.getParent().getParent().toString());
        Assert.assertEquals((Object)"/xy z/a b c", (Object)uri.getPath());
        Assert.assertEquals((Object)"hdfs", (Object)uri.getScheme());
        Assert.assertTrue((boolean)uri.hasScheme());
        Assert.assertTrue((boolean)uri.isAbsolute());
        Assert.assertTrue((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"hdfs://localhost:8020/xy z/a b c/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"hdfs://localhost:8020/xy z/a b c/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"hdfs://localhost:8020/xy z/a b c", (Object)uri.toString());
    }

    @Test
    public void basicTwoPartUri() {
        AlluxioURI uri = new AlluxioURI("scheme:part2://localhost:8000/xy z/a b c");
        Assert.assertEquals((Object)uri, (Object)new AlluxioURI("scheme:part2//localhost:8000/xy z/a b c"));
        Assert.assertEquals((Object)"scheme:part2", (Object)uri.getScheme());
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"localhost:8000", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof SingleMasterAuthority));
        SingleMasterAuthority authority = (SingleMasterAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"localhost", (Object)authority.getHost());
        Assert.assertEquals((long)8000L, (long)authority.getPort());
        Assert.assertEquals((long)2L, (long)uri.getDepth());
        Assert.assertEquals((Object)"a b c", (Object)uri.getName());
        Assert.assertEquals((Object)"scheme:part2://localhost:8000/xy z", (Object)uri.getParent().toString());
        Assert.assertEquals((Object)"scheme:part2://localhost:8000/", (Object)uri.getParent().getParent().toString());
        Assert.assertEquals((Object)"/xy z/a b c", (Object)uri.getPath());
        Assert.assertTrue((boolean)uri.hasScheme());
        Assert.assertTrue((boolean)uri.isAbsolute());
        Assert.assertTrue((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"scheme:part2://localhost:8000/xy z/a b c/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"scheme:part2://localhost:8000/xy z/a b c/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"scheme:part2://localhost:8000/xy z/a b c", (Object)uri.toString());
    }

    @Test
    public void basicMultiMasterUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://host1:19998,host2:19998,host3:19998/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof MultiMasterAuthority));
        Assert.assertEquals((long)2L, (long)uri.getDepth());
        Assert.assertEquals((Object)"a b c", (Object)uri.getName());
        Assert.assertEquals((Object)"alluxio://host1:19998,host2:19998,host3:19998/xy z", (Object)uri.getParent().toString());
        Assert.assertEquals((Object)"alluxio://host1:19998,host2:19998,host3:19998/", (Object)uri.getParent().getParent().toString());
        Assert.assertEquals((Object)"/xy z/a b c", (Object)uri.getPath());
        Assert.assertEquals((Object)"alluxio", (Object)uri.getScheme());
        Assert.assertTrue((boolean)uri.hasScheme());
        Assert.assertTrue((boolean)uri.isAbsolute());
        Assert.assertTrue((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"alluxio://host1:19998,host2:19998,host3:19998/xy z/a b c/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"alluxio://host1:19998,host2:19998,host3:19998/xy z/a b c/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"alluxio://host1:19998,host2:19998,host3:19998/xy z/a b c", (Object)uri.toString());
    }

    @Test
    public void semicolonMultiMasterUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://host1:1323;host2:54325;host3:64354/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"host1:1323,host2:54325,host3:64354", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof MultiMasterAuthority));
        MultiMasterAuthority authority = (MultiMasterAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"host1:1323,host2:54325,host3:64354", (Object)authority.getMasterAddresses());
    }

    @Test
    public void plusMultiMasterUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://host1:526+host2:54325+host3:624/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof MultiMasterAuthority));
        MultiMasterAuthority authority = (MultiMasterAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"host1:526,host2:54325,host3:624", (Object)authority.getMasterAddresses());
    }

    @Test
    public void basicZookeeperUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://zk@host1:2181,host2:2181,host3:2181/xy z/a b c");
        Assert.assertEquals((Object)uri, (Object)new AlluxioURI("alluxio://zk@host1:2181,host2:2181,host3:2181/xy z/a b c"));
        Assert.assertEquals((Object)"alluxio", (Object)uri.getScheme());
        Assert.assertEquals((Object)"zk@host1:2181,host2:2181,host3:2181", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof ZookeeperAuthority));
        ZookeeperAuthority zkAuthority = (ZookeeperAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)zkAuthority.getZookeeperAddress());
        Assert.assertEquals((long)2L, (long)uri.getDepth());
        Assert.assertEquals((Object)"a b c", (Object)uri.getName());
        Assert.assertEquals((Object)"alluxio://zk@host1:2181,host2:2181,host3:2181/xy z", (Object)uri.getParent().toString());
        Assert.assertEquals((Object)"alluxio://zk@host1:2181,host2:2181,host3:2181/", (Object)uri.getParent().getParent().toString());
        Assert.assertEquals((Object)"/xy z/a b c", (Object)uri.getPath());
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertTrue((boolean)uri.hasScheme());
        Assert.assertTrue((boolean)uri.isAbsolute());
        Assert.assertTrue((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"alluxio://zk@host1:2181,host2:2181,host3:2181/xy z/a b c/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"alluxio://zk@host1:2181,host2:2181,host3:2181/xy z/a b c/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"alluxio://zk@host1:2181,host2:2181,host3:2181/xy z/a b c", (Object)uri.toString());
    }

    @Test
    public void semicolonZookeeperUri() {
        AlluxioURI uri = new AlluxioURI("alluxio://zk@host1:2181;host2:2181;host3:2181/xy z/a b c");
        Assert.assertTrue((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"zk@host1:2181,host2:2181,host3:2181", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof ZookeeperAuthority));
        ZookeeperAuthority zkAuthority = (ZookeeperAuthority)uri.getAuthority();
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)zkAuthority.getZookeeperAddress());
    }

    @Test
    public void basicConstructorQuery() {
        String queryPart = "k1=v1&k2= spaces &k3=%3D%20escapes %20%25%26%2B&!@#$^*()-_=[]{};\"'<>,./";
        AlluxioURI uri = new AlluxioURI("hdfs://localhost/a?" + queryPart);
        Map queryMap = uri.getQueryMap();
        Assert.assertEquals((long)4L, (long)queryMap.size());
        Assert.assertEquals((Object)"v1", queryMap.get("k1"));
        Assert.assertEquals((Object)" spaces ", queryMap.get("k2"));
        Assert.assertEquals((Object)"= escapes  %&+", queryMap.get("k3"));
        Assert.assertEquals((Object)"[]{};\"'<>,./", queryMap.get("!@#$^*()-_"));
    }

    @Test
    public void basicTests() {
        String[] strs;
        for (String str : strs = new String[]{"alluxio://localhost:19998/xyz/abc", "hdfs://localhost:19998/xyz/abc", "s3://localhost:19998/xyz/abc", "alluxio://localhost:19998/xy z/a b c", "hdfs://localhost:19998/xy z/a b c", "s3://localhost:19998/xy z/a b c"}) {
            AlluxioURI uri = new AlluxioURI(str);
            Assert.assertEquals((Object)str, (Object)uri.toString());
            Assert.assertEquals((long)2L, (long)uri.getDepth());
            Assert.assertTrue((boolean)(uri.getAuthority() instanceof SingleMasterAuthority));
            SingleMasterAuthority authority = (SingleMasterAuthority)uri.getAuthority();
            Assert.assertEquals((Object)"localhost", (Object)authority.getHost());
            Assert.assertEquals((long)19998L, (long)authority.getPort());
        }
    }

    @Test
    public void emptyURI() {
        AlluxioURI uri = new AlluxioURI("");
        Assert.assertEquals((Object)"", (Object)uri.getAuthority().toString());
        Assert.assertTrue((boolean)(uri.getAuthority() instanceof NoAuthority));
        Assert.assertEquals((long)0L, (long)uri.getDepth());
        Assert.assertEquals((Object)"", (Object)uri.getName());
        Assert.assertEquals((Object)"", (Object)uri.getPath());
        Assert.assertEquals(null, (Object)uri.getScheme());
        Assert.assertFalse((boolean)uri.hasAuthority());
        Assert.assertFalse((boolean)uri.hasScheme());
        Assert.assertFalse((boolean)uri.isAbsolute());
        Assert.assertFalse((boolean)uri.isPathAbsolute());
        Assert.assertEquals((Object)"/d", (Object)uri.join("/d").toString());
        Assert.assertEquals((Object)"/d", (Object)uri.join(new AlluxioURI("/d")).toString());
        Assert.assertEquals((Object)"", (Object)uri.toString());
    }

    @Test
    public void pathWithWhiteSpaces() {
        String[] paths;
        for (String path : paths = new String[]{"/ ", "/  ", "/ path", "/path ", "/pa th", "/ pa th ", "/pa/ th", "/pa / th", "/ pa / th "}) {
            AlluxioURI uri = new AlluxioURI(path);
            Assert.assertEquals((Object)path, (Object)uri.getPath());
            Assert.assertEquals((Object)path, (Object)uri.toString());
            Assert.assertTrue((boolean)uri.isPathAbsolute());
        }
    }

    @Test
    public void constructFromComponentsTests() {
        String scheme = "alluxio";
        String authority = "127.0.0.1:90909";
        String path = "/a/../b/c.txt";
        String absPath = "/b/c.txt";
        AlluxioURI uri0 = new AlluxioURI(null, null, path);
        Assert.assertEquals((Object)absPath, (Object)uri0.toString());
        AlluxioURI uri1 = new AlluxioURI(scheme, null, path);
        Assert.assertEquals((Object)(scheme + "://" + absPath), (Object)uri1.toString());
        AlluxioURI uri2 = new AlluxioURI(scheme, Authority.fromString((String)authority), path);
        Assert.assertEquals((Object)(scheme + "://" + authority + absPath), (Object)uri2.toString());
        AlluxioURI uri3 = new AlluxioURI(null, Authority.fromString((String)authority), path);
        Assert.assertEquals((Object)("//" + authority + absPath), (Object)uri3.toString());
        AlluxioURI uri4 = new AlluxioURI("scheme:part1", Authority.fromString((String)authority), path);
        Assert.assertEquals((Object)("scheme:part1://" + authority + absPath), (Object)uri4.toString());
        AlluxioURI uri5 = new AlluxioURI("scheme:part1:part2", Authority.fromString((String)authority), path);
        Assert.assertEquals((Object)("scheme:part1:part2://" + authority + absPath), (Object)uri5.toString());
    }

    @Test
    public void constructWithQueryMap() {
        String scheme = "alluxio";
        String authority = "host:1234";
        String path = "/a";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("key", "123");
        queryMap.put(" k2 ", " v2 ");
        queryMap.put(" key: !*'();:@&=+$,/?#[]\"% ", " !*'();:@&=+$,/?#[]\"% ");
        queryMap.put(" key: %26 %3D %20 %25 %2B ", " %26 %3D %20 %25 %2B ");
        AlluxioURI uri1 = new AlluxioURI(scheme, Authority.fromString((String)authority), path, queryMap);
        AlluxioURI uri2 = new AlluxioURI(uri1.toString());
        Assert.assertEquals(queryMap, (Object)uri1.getQueryMap());
        Assert.assertEquals((Object)uri1.getQueryMap(), (Object)uri2.getQueryMap());
    }

    @Test
    public void constructFromParentAndChildTests() {
        this.testParentChild("", ".", ".");
        this.testParentChild("/", "/", ".");
        this.testParentChild("/", ".", "/");
        this.testParentChild("hdfs://localhost:8080/a/b/d.txt", "hdfs://localhost:8080/a/b/c.txt", "../d.txt");
        this.testParentChild("/foo/bar", "/foo", "bar");
        this.testParentChild("/foo/bar/baz", "/foo/bar", "baz");
        this.testParentChild("/foo/bar/baz", "/foo", "bar/baz");
        this.testParentChild("foo/bar", "foo", "bar");
        this.testParentChild("foo/bar/baz", "foo", "bar/baz");
        this.testParentChild("foo/bar/baz", "foo/bar", "baz");
        this.testParentChild("/foo", "/bar", "/foo");
        this.testParentChild("c:/foo", "/bar", "c:/foo");
        this.testParentChild("c:/foo", "d:/bar", "c:/foo");
        this.testParentChild("/foo/bar/baz/boo", "/foo/bar", "baz/boo");
        this.testParentChild("foo/bar/baz/bud", "foo/bar/", "baz/bud");
        this.testParentChild("/boo/bud", "/foo/bar", "../../boo/bud");
        this.testParentChild("boo/bud", "foo/bar", "../../boo/bud");
        this.testParentChild("/foo/boo/bud", "/foo/bar/baz", "../../boo/bud");
        this.testParentChild("foo/boo/bud", "foo/bar/baz", "../../boo/bud");
        this.testParentChild("../../../../boo/bud", "../../", "../../boo/bud");
        this.testParentChild("../../../../boo/bud", "../../foo", "../../../boo/bud");
        this.testParentChild("../../foo/boo/bud", "../../foo/bar", "../boo/bud");
        this.testParentChild("", "foo/bar/baz", "../../..");
        this.testParentChild("../..", "foo/bar/baz", "../../../../..");
        this.testParentChild("foo://bar boo:80/.", "foo://bar boo:80/.", ".");
        this.testParentChild("foo://bar boo:80/", "foo://bar boo:80/", ".");
        this.testParentChild("foo://bar boo:80/", "foo://bar boo:80/.", "/");
        this.testParentChild("foo://bar boo:80/foo", "foo://bar boo:80/", "foo");
        this.testParentChild("foo://bar boo:80/foo/bar", "foo://bar boo:80/foo", "bar");
        this.testParentChild("foo://bar boo:80/foo/bar/baz", "foo://bar boo:80/foo/bar", "baz");
        this.testParentChild("foo://bar boo:80/foo", "foo://bar boo:80/.", "foo");
        this.testParentChild("foo://bar boo:80/foo/bar/baz", "foo://bar boo:80/foo", "bar/baz");
        this.testParentChild("foo://bar boo:80/foo/bar/baz", "foo://bar boo:80/foo/bar", "baz");
        this.testParentChild("foo://bar boo:80/foo", "foo://bar boo:80/bar", "/foo");
        this.testParentChild("foo://bar boo:80/c:/foo", "foo://bar boo:80/bar", "c:/foo");
        this.testParentChild("foo://bar boo:80/c:/foo", "foo://bar boo:80/d:/bar", "c:/foo");
        this.testParentChild("foo://bar boo:80/c:/foo", "foo://bar boo:80/d:/bar", "foo://bar boo:80/c:/foo");
        this.testParentChild("parent://host:1234/a/d.txt", "parent://host:1234/a", "d.txt");
        this.testParentChild("parent:part1://host:1234/a/d.txt", "parent:part1://host:1234/a", "d.txt");
        this.testParentChild("parent:part1:part2://host:1234/a/d.txt", "parent:part1:part2://host:1234/a", "d.txt");
        this.testParentChild("child://h:1/d.txt", "parent://host:1234/a", "child://h:1/d.txt");
        this.testParentChild("child:part1://h:1/d.txt", "parent://host:1234/a", "child:part1://h:1/d.txt");
        this.testParentChild("child:part1:part2://h:1/d.txt", "parent://host:1234/a", "child:part1:part2://h:1/d.txt");
    }

    @Test
    public void compareToTests() {
        AlluxioURI[] uris = new AlluxioURI[]{new AlluxioURI("file://127.0.0.0:8081/a/b/c.txt"), new AlluxioURI("glusterfs://127.0.0.0:8081/a/b/c.txt"), new AlluxioURI("hdfs://127.0.0.0:8081/a/b/c.txt"), new AlluxioURI("hdfs://127.0.0.1:8081/a/b/c.txt"), new AlluxioURI("hdfs://127.0.0.1:8081/a/b/d.txt"), new AlluxioURI("hdfs://127.0.0.1:8081/a/c/c.txt"), new AlluxioURI("hdfs://127.0.0.1:8082/a/c/c.txt"), new AlluxioURI("hdfs://localhost:8080/a/b/c.txt"), new AlluxioURI("s3://localhost:8080/a/b/c.txt"), new AlluxioURI("scheme://localhost:8080/a.txt"), new AlluxioURI("scheme://localhost:8080/a.txt?a=a"), new AlluxioURI("scheme://localhost:8080/a.txt?b=b"), new AlluxioURI("scheme://localhost:8080/a.txt?c=c"), new AlluxioURI("scheme:scheme://localhost:8080/a.txt"), new AlluxioURI("scheme:scheme://localhost:8080/b.txt"), new AlluxioURI("scheme:schemeB://localhost:8080/a.txt"), new AlluxioURI("scheme:schemeB://localhost:8080/b.txt"), new AlluxioURI("schemeA:scheme://localhost:8080/a.txt"), new AlluxioURI("schemeA:scheme://localhost:8080/b.txt"), new AlluxioURI("schemeA:schemeB:schemeC://localhost:8080/a.txt"), new AlluxioURI("schemeA:schemeB:schemeC://localhost:8080/b.txt"), new AlluxioURI("schemeA:schemeB:schemeD://localhost:8080/a.txt"), new AlluxioURI("schemeA:schemeB:schemeD://localhost:8080/b.txt"), new AlluxioURI("schemeE:schemeB:schemeB://localhost:8080/a.txt"), new AlluxioURI("schemeE:schemeB:schemeB://localhost:8080/b.txt")};
        for (int i = 0; i < uris.length - 1; ++i) {
            Assert.assertTrue((uris[i].compareTo(uris[i + 1]) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((uris[i + 1].compareTo(uris[i]) > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)uris[i].compareTo(uris[i]));
        }
    }

    @Test
    public void equalsTests() {
        Assert.assertFalse((boolean)new AlluxioURI("alluxio://127.0.0.1:8080/a/b/c.txt").equals((Object)new AlluxioURI("alluxio://localhost:8080/a/b/c.txt")));
        AlluxioURI[] uriFromDifferentConstructor = new AlluxioURI[]{new AlluxioURI("alluxio://127.0.0.1:8080/a/b/c.txt"), new AlluxioURI("alluxio", Authority.fromString((String)"127.0.0.1:8080"), "/a/b/c.txt"), new AlluxioURI(new AlluxioURI("alluxio://127.0.0.1:8080/a"), new AlluxioURI("b/c.txt"))};
        for (int i = 0; i < uriFromDifferentConstructor.length - 1; ++i) {
            Assert.assertTrue((boolean)uriFromDifferentConstructor[i].equals((Object)uriFromDifferentConstructor[i + 1]));
        }
    }

    @Test
    public void multiPartSchemeEquals() {
        Assert.assertTrue((boolean)new AlluxioURI("scheme:part1://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("scheme:part1://127.0.0.1:3306/a.txt")));
        Assert.assertFalse((boolean)new AlluxioURI("part1://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("scheme:part1://127.0.0.1:3306/a.txt")));
        Assert.assertFalse((boolean)new AlluxioURI("scheme:part1://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("part1://127.0.0.1:3306/a.txt")));
        Assert.assertTrue((boolean)new AlluxioURI("scheme:part1:part2://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("scheme:part1:part2://127.0.0.1:3306/a.txt")));
        Assert.assertFalse((boolean)new AlluxioURI("part2://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("scheme:part1:part2://127.0.0.1:3306/a.txt")));
        Assert.assertFalse((boolean)new AlluxioURI("scheme:part1:part2://127.0.0.1:3306/a.txt").equals((Object)new AlluxioURI("part2://127.0.0.1:3306/a.txt")));
        new EqualsTester().addEqualityGroup(new Object[]{new AlluxioURI("sch:p1:p2://aaaabbbb:12345/"), new AlluxioURI("sch:p1:p2://aaaabbbb:12345/")}).addEqualityGroup(new Object[]{new AlluxioURI("standard://host:12345/")}).testEquals();
    }

    @Test
    public void queryEquals() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("a", "b");
        queryMap.put("c", "d");
        Assert.assertTrue((boolean)new AlluxioURI("scheme://host:123/a.txt?a=b&c=d").equals((Object)new AlluxioURI("scheme://host:123/a.txt?a=b&c=d")));
        Assert.assertTrue((new AlluxioURI("scheme://host:123/a.txt?c=d&a=b").equals((Object)new AlluxioURI("scheme", Authority.fromString((String)"host:123"), "/a.txt", queryMap)) || new AlluxioURI("scheme://host:123/a.txt?a=b&c=d").equals((Object)new AlluxioURI("scheme", Authority.fromString((String)"host:123"), "/a.txt", queryMap)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)new AlluxioURI("scheme://host:123/a.txt?a=b&c=d&e=f").equals((Object)new AlluxioURI("scheme://host:123/a.txt?a=b&c=d")));
        Assert.assertFalse((boolean)new AlluxioURI("scheme://host:123/a.txt?a=b&c=d&e=f").equals((Object)new AlluxioURI("scheme", Authority.fromString((String)"host:123"), "/a.txt", queryMap)));
    }

    @Test
    public void getAuthorityTests() {
        String[] authorities;
        for (String authority : authorities = new String[]{"localhost", "localhost:8080", "127.0.0.1", "127.0.0.1:8080", "localhost"}) {
            AlluxioURI uri = new AlluxioURI("file", Authority.fromString((String)authority), "/a/b");
            Assert.assertEquals((Object)authority, (Object)uri.getAuthority().toString());
        }
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("file", Authority.fromString((String)""), "/b/c").getAuthority().toString());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("file", null, "/b/c").getAuthority().toString());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("file", Authority.fromString(null), "/b/c").getAuthority().toString());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("file:///b/c").getAuthority().toString());
    }

    @Test
    public void authorityTypeTests() {
        Assert.assertTrue((boolean)(new AlluxioURI("file", Authority.fromString((String)"localhost:8080"), "/b/c").getAuthority() instanceof SingleMasterAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file", Authority.fromString((String)"zk@host:2181"), "/b/c").getAuthority() instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("alluxio://zk@host1:2181,host2:2181,host3:2181/b/c").getAuthority() instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("alluxio://zk@host1:2181;host2:2181;host3:2181/b/c").getAuthority() instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file", Authority.fromString((String)""), "/b/c").getAuthority() instanceof NoAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file", null, "/b/c").getAuthority() instanceof NoAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file", Authority.fromString(null), "/b/c").getAuthority() instanceof NoAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file:///b/c").getAuthority() instanceof NoAuthority));
        Assert.assertTrue((boolean)(new AlluxioURI("file", Authority.fromString((String)"localhost"), "/b/c").getAuthority() instanceof UnknownAuthority));
    }

    @Test
    public void getDepthTests() {
        Assert.assertEquals((long)0L, (long)new AlluxioURI("").getDepth());
        Assert.assertEquals((long)0L, (long)new AlluxioURI(".").getDepth());
        Assert.assertEquals((long)0L, (long)new AlluxioURI("/").getDepth());
        Assert.assertEquals((long)1L, (long)new AlluxioURI("/a").getDepth());
        Assert.assertEquals((long)3L, (long)new AlluxioURI("/a/b/c.txt").getDepth());
        Assert.assertEquals((long)2L, (long)new AlluxioURI("/a/b/").getDepth());
        Assert.assertEquals((long)2L, (long)new AlluxioURI("a\\b").getDepth());
        Assert.assertEquals((long)1L, (long)new AlluxioURI("C:\\a").getDepth());
        Assert.assertEquals((long)1L, (long)new AlluxioURI("C:\\\\a").getDepth());
        Assert.assertEquals((long)0L, (long)new AlluxioURI("C:\\\\").getDepth());
        Assert.assertEquals((long)0L, (long)new AlluxioURI("alluxio://localhost:19998/").getDepth());
        Assert.assertEquals((long)1L, (long)new AlluxioURI("alluxio://localhost:19998/a").getDepth());
        Assert.assertEquals((long)2L, (long)new AlluxioURI("alluxio://localhost:19998/a/b.txt").getDepth());
    }

    @Test
    public void getNameTests() {
        Assert.assertEquals((Object)".", (Object)new AlluxioURI(".").getName());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("/").getName());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("alluxio://localhost/").getName());
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("alluxio:/").getName());
        Assert.assertEquals((Object)"a", (Object)new AlluxioURI("alluxio:/a/").getName());
        Assert.assertEquals((Object)"a.txt", (Object)new AlluxioURI("alluxio:/a.txt/").getName());
        Assert.assertEquals((Object)" b.txt", (Object)new AlluxioURI("alluxio:/a/ b.txt").getName());
        Assert.assertEquals((Object)"a.txt", (Object)new AlluxioURI("/a/a.txt").getName());
    }

    @Test
    public void getParentTests() {
        Assert.assertEquals(null, (Object)new AlluxioURI("/").getParent());
        Assert.assertEquals(null, (Object)new AlluxioURI("alluxio://localhost/").getParent());
        Assert.assertEquals((Object)new AlluxioURI("alluxio://localhost/"), (Object)new AlluxioURI("alluxio://localhost/a").getParent());
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/a/b/../c").getParent());
        Assert.assertEquals((Object)new AlluxioURI("alluxio:/a"), (Object)new AlluxioURI("alluxio:/a/b/../c").getParent());
        Assert.assertEquals((Object)new AlluxioURI("alluxio://localhost:80/a"), (Object)new AlluxioURI("alluxio://localhost:80/a/b/../c").getParent());
    }

    @Test
    public void getPathTests() {
        Assert.assertEquals((Object)".", (Object)new AlluxioURI(".").getPath());
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("/").getPath());
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("alluxio:/").getPath());
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("alluxio://localhost:80/").getPath());
        Assert.assertEquals((Object)"/a.txt", (Object)new AlluxioURI("alluxio://localhost:80/a.txt").getPath());
        Assert.assertEquals((Object)"/b", (Object)new AlluxioURI("alluxio://localhost:80/a/../b").getPath());
        Assert.assertEquals((Object)"/b", (Object)new AlluxioURI("alluxio://localhost:80/a/c/../../b").getPath());
        Assert.assertEquals((Object)"/a/b", (Object)new AlluxioURI("alluxio://localhost:80/a/./b").getPath());
        Assert.assertEquals((Object)"/a/b", (Object)new AlluxioURI("/a/b").getPath());
        Assert.assertEquals((Object)"/a/b", (Object)new AlluxioURI("file:///a/b").getPath());
    }

    @Test
    public void getSchemeTests() {
        Assert.assertEquals(null, (Object)new AlluxioURI(".").getScheme());
        Assert.assertEquals(null, (Object)new AlluxioURI("/").getScheme());
        Assert.assertEquals((Object)"file", (Object)new AlluxioURI("file:/").getScheme());
        Assert.assertEquals((Object)"file", (Object)new AlluxioURI("file://localhost/").getScheme());
        Assert.assertEquals((Object)"s3", (Object)new AlluxioURI("s3://localhost/").getScheme());
        Assert.assertEquals((Object)"alluxio", (Object)new AlluxioURI("alluxio://localhost/").getScheme());
        Assert.assertEquals((Object)"hdfs", (Object)new AlluxioURI("hdfs://localhost/").getScheme());
        Assert.assertEquals((Object)"glusterfs", (Object)new AlluxioURI("glusterfs://localhost/").getScheme());
        Assert.assertEquals((Object)"scheme:part1", (Object)new AlluxioURI("scheme:part1://localhost/").getScheme());
        Assert.assertEquals((Object)"scheme:part1:part2", (Object)new AlluxioURI("scheme:part1:part2://localhost/").getScheme());
    }

    @Test
    public void hasAuthorityTests() {
        Assert.assertFalse((boolean)new AlluxioURI(".").hasAuthority());
        Assert.assertFalse((boolean)new AlluxioURI("/").hasAuthority());
        Assert.assertFalse((boolean)new AlluxioURI("file:/").hasAuthority());
        Assert.assertFalse((boolean)new AlluxioURI("file:///test").hasAuthority());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/").hasAuthority());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost:8080/").hasAuthority());
        Assert.assertTrue((boolean)new AlluxioURI(null, Authority.fromString((String)"localhost:8080"), "/").hasAuthority());
        Assert.assertTrue((boolean)new AlluxioURI(null, Authority.fromString((String)"localhost"), "/").hasAuthority());
    }

    @Test
    public void hasScheme() {
        Assert.assertFalse((boolean)new AlluxioURI("/").hasScheme());
        Assert.assertTrue((boolean)new AlluxioURI("file:/").hasScheme());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/").hasScheme());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost:8080/").hasScheme());
        Assert.assertFalse((boolean)new AlluxioURI("//localhost:8080/").hasScheme());
    }

    @Test
    public void isAbsoluteTests() {
        Assert.assertTrue((boolean)new AlluxioURI("file:/a").isAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/a").isAbsolute());
        Assert.assertFalse((boolean)new AlluxioURI("//localhost/a").isAbsolute());
        Assert.assertFalse((boolean)new AlluxioURI("//localhost/").isAbsolute());
        Assert.assertFalse((boolean)new AlluxioURI("/").isAbsolute());
    }

    @Test
    public void isPathAbsoluteTests() {
        Assert.assertFalse((boolean)new AlluxioURI(".").isPathAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("/").isPathAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("file:/").isPathAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/").isPathAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/a/b").isPathAbsolute());
        Assert.assertFalse((boolean)new AlluxioURI("a/b").isPathAbsolute());
        Assert.assertTrue((boolean)new AlluxioURI("C:\\\\a\\b").isPathAbsolute());
    }

    @Test
    public void isRootTests() {
        Assert.assertFalse((boolean)new AlluxioURI(".").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("/").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("file:/").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("alluxio://localhost:19998").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("alluxio://localhost:19998/").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("hdfs://localhost:19998").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("hdfs://localhost:19998/").isRoot());
        Assert.assertTrue((boolean)new AlluxioURI("file://localhost/").isRoot());
        Assert.assertFalse((boolean)new AlluxioURI("file://localhost/a/b").isRoot());
        Assert.assertFalse((boolean)new AlluxioURI("a/b").isRoot());
    }

    @Test
    public void joinTests() {
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/").join("a"));
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/").join(new AlluxioURI("a")));
        Assert.assertEquals((Object)new AlluxioURI("/a/b"), (Object)new AlluxioURI("/a").join(new AlluxioURI("b")));
        Assert.assertEquals((Object)new AlluxioURI("a/b"), (Object)new AlluxioURI("a").join(new AlluxioURI("b")));
        Assert.assertEquals((Object)new AlluxioURI("/a/c"), (Object)new AlluxioURI("/a").join(new AlluxioURI("b/../c")));
        Assert.assertEquals((Object)new AlluxioURI("a/b.txt"), (Object)new AlluxioURI("a").join(new AlluxioURI("/b.txt")));
        Assert.assertEquals((Object)new AlluxioURI("a/b.txt"), (Object)new AlluxioURI("a").join(new AlluxioURI("/c/../b.txt")));
        Assert.assertEquals((Object)new AlluxioURI("alluxio:/a/b.txt"), (Object)new AlluxioURI("alluxio:/a").join("/b.txt"));
        Assert.assertEquals((Object)new AlluxioURI("alluxio:/a/b.txt"), (Object)new AlluxioURI("alluxio:/a/c.txt").join(new AlluxioURI("/../b.txt")));
        Assert.assertEquals((Object)new AlluxioURI("C:\\\\a\\b"), (Object)new AlluxioURI("C:\\\\a").join(new AlluxioURI("\\b")));
        Assert.assertEquals((Object)new AlluxioURI("/a/b"), (Object)new AlluxioURI("/a").joinUnsafe("///b///"));
        String pathWithSpecialChar = "\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd";
        Assert.assertEquals((Object)new AlluxioURI("/\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd"), (Object)new AlluxioURI("/").join("\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd"));
        String pathWithSpecialCharAndColon = "\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd";
        Assert.assertEquals((Object)new AlluxioURI("/\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd"), (Object)new AlluxioURI("/").join("\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd"));
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/a").join(""));
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/a").join(new AlluxioURI("")));
    }

    @Test
    public void joinUnsafe() {
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/").joinUnsafe("a"));
        Assert.assertEquals((Object)new AlluxioURI("/a/b"), (Object)new AlluxioURI("/a").joinUnsafe("b"));
        Assert.assertEquals((Object)new AlluxioURI("a/b"), (Object)new AlluxioURI("a").joinUnsafe("b"));
        Assert.assertEquals((Object)new AlluxioURI("a/b.txt"), (Object)new AlluxioURI("a").joinUnsafe("/b.txt"));
        Assert.assertEquals((Object)new AlluxioURI("alluxio:/a/b.txt"), (Object)new AlluxioURI("alluxio:/a").joinUnsafe("/b.txt"));
        Assert.assertEquals((Object)new AlluxioURI("C:\\\\a\\b"), (Object)new AlluxioURI("C:\\\\a").joinUnsafe("\\b"));
        Assert.assertEquals((Object)new AlluxioURI("/a/b"), (Object)new AlluxioURI("/a").joinUnsafe("///b///"));
        String pathWithSpecialChar = "\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd";
        Assert.assertEquals((Object)new AlluxioURI("/\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd"), (Object)new AlluxioURI("/").joinUnsafe("\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd\ufffd\ufffd"));
        String pathWithSpecialCharAndColon = "\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd";
        Assert.assertEquals((Object)new AlluxioURI("/\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd"), (Object)new AlluxioURI("/").joinUnsafe("\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffdb\ufffd\ufffd\ufffd\ufffd$o\ufffd\ufffd\ufffd\ufffd[| =B\ufffd\ufffd:\ufffd\ufffd"));
        Assert.assertNotEquals((Object)new AlluxioURI("/a/c"), (Object)new AlluxioURI("/a").joinUnsafe("b/../c"));
        Assert.assertNotEquals((Object)new AlluxioURI("a/b.txt"), (Object)new AlluxioURI("a").joinUnsafe("/c/../b.txt"));
        Assert.assertNotEquals((Object)new AlluxioURI("alluxio:/a/b.txt"), (Object)new AlluxioURI("alluxio:/a/c.txt").joinUnsafe("/../b.txt"));
        Assert.assertEquals((Object)new AlluxioURI("/a"), (Object)new AlluxioURI("/a").joinUnsafe(""));
    }

    @Test
    public void fileUriTests() {
        AlluxioURI uri = new AlluxioURI("file:///foo/bar");
        Assert.assertFalse((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"file:///foo/bar", (Object)uri.toString());
    }

    @Test
    public void windowsPathTests() {
        Assume.assumeTrue((boolean)WINDOWS);
        AlluxioURI uri = new AlluxioURI("C:\\foo\\bar");
        Assert.assertFalse((boolean)uri.hasAuthority());
        Assert.assertEquals((Object)"/C:/foo/bar", (Object)uri.getPath());
        Assert.assertEquals((Object)"C:/foo/bar", (Object)uri.toString());
    }

    @Test
    public void toStringTests() {
        String[] uris;
        for (String uri : uris = new String[]{"/", "/a", "/a/ b", "alluxio://a/b/c d.txt", "alluxio://localhost:8080/a/b.txt", "foo", "foo/bar", "/foo/bar#boo", "foo/bar#boo", "file:///foo/bar"}) {
            AlluxioURI turi = new AlluxioURI(uri);
            Assert.assertEquals((Object)uri, (Object)turi.toString());
        }
        Assert.assertEquals((Object)".", (Object)new AlluxioURI(".").toString());
        Assert.assertEquals((Object)"file:///a", (Object)new AlluxioURI("file:///a").toString());
        Assert.assertEquals((Object)"file:///a", (Object)new AlluxioURI("file", null, "/a").toString());
    }

    @Test
    public void toStringWindowsTests() {
        String[] uris;
        Assume.assumeTrue((boolean)WINDOWS);
        for (String uri : uris = new String[]{"c:/", "c:/foo/bar", "C:/foo/bar#boo", "C:/foo/ bar"}) {
            AlluxioURI turi = new AlluxioURI(uri);
            Assert.assertEquals((Object)uri, (Object)turi.toString());
        }
        Assert.assertEquals((Object)"C:/", (Object)new AlluxioURI("C:\\\\").toString());
        Assert.assertEquals((Object)"C:/a/b.txt", (Object)new AlluxioURI("C:\\\\a\\b.txt").toString());
    }

    @Test
    public void normalizeTests() {
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("//").toString());
        Assert.assertEquals((Object)"/foo", (Object)new AlluxioURI("/foo/").toString());
        Assert.assertEquals((Object)"/foo", (Object)new AlluxioURI("/foo/").toString());
        Assert.assertEquals((Object)"foo", (Object)new AlluxioURI("foo/").toString());
        Assert.assertEquals((Object)"foo", (Object)new AlluxioURI("foo//").toString());
        Assert.assertEquals((Object)"foo/bar", (Object)new AlluxioURI("foo//bar").toString());
        Assert.assertEquals((Object)"foo/boo", (Object)new AlluxioURI("foo/bar/..//boo").toString());
        Assert.assertEquals((Object)"foo/boo/baz", (Object)new AlluxioURI("foo/bar/..//boo/./baz").toString());
        Assert.assertEquals((Object)"../foo/boo", (Object)new AlluxioURI("../foo/bar/..//boo").toString());
        Assert.assertEquals((Object)"/../foo/boo", (Object)new AlluxioURI("/.././foo/boo").toString());
        Assert.assertEquals((Object)"foo/boo", (Object)new AlluxioURI("./foo/boo").toString());
        Assert.assertEquals((Object)"foo://bar boo:8080/abc/c", (Object)new AlluxioURI("foo://bar boo:8080/abc///c").toString());
    }

    @Test
    public void normalizeWindowsTests() {
        Assume.assumeTrue((boolean)WINDOWS);
        Assert.assertEquals((Object)"c:/a/b", (Object)new AlluxioURI("c:\\a\\b").toString());
        Assert.assertEquals((Object)"c:/a/c", (Object)new AlluxioURI("c:\\a\\b\\..\\c").toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructFromEmptyPathTest2() {
        new AlluxioURI(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructFromEmptyPathTest3() {
        new AlluxioURI("file", null, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidURISyntax() {
        new AlluxioURI("://localhost:8080/a");
    }

    private void testParentChild(String target, String parent, String child) {
        if (target.length() > 0) {
            Assert.assertEquals((Object)new AlluxioURI(target), (Object)new AlluxioURI(new AlluxioURI(parent), new AlluxioURI(child)));
        } else {
            Assert.assertEquals((Object)target, (Object)new AlluxioURI(new AlluxioURI(parent), new AlluxioURI(child)).toString());
        }
    }

    @Test
    public void getLeadingPath() {
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("/a/b/c/").getLeadingPath(0));
        Assert.assertEquals((Object)"/a", (Object)new AlluxioURI("/a/b/c/").getLeadingPath(1));
        Assert.assertEquals((Object)"/a/b", (Object)new AlluxioURI("/a/b/c/").getLeadingPath(2));
        Assert.assertEquals((Object)"/a/b/c", (Object)new AlluxioURI("/a/b/c/").getLeadingPath(3));
        Assert.assertEquals(null, (Object)new AlluxioURI("/a/b/c/").getLeadingPath(4));
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("/").getLeadingPath(0));
        Assert.assertEquals((Object)"", (Object)new AlluxioURI("").getLeadingPath(0));
        Assert.assertEquals(null, (Object)new AlluxioURI("").getLeadingPath(1));
        Assert.assertEquals((Object)".", (Object)new AlluxioURI(".").getLeadingPath(0));
        Assert.assertEquals(null, (Object)new AlluxioURI(".").getLeadingPath(1));
        Assert.assertEquals((Object)"a/b", (Object)new AlluxioURI("a/b/c").getLeadingPath(1));
    }

    @Test
    public void getRootPath() {
        Assert.assertEquals((Object)"s3a://s3-bucket-name/", (Object)new AlluxioURI("s3a://s3-bucket-name/").getRootPath());
        Assert.assertEquals((Object)"s3a://s3-bucket-name/", (Object)new AlluxioURI("s3a://s3-bucket-name/folder").getRootPath());
        Assert.assertEquals((Object)"/", (Object)new AlluxioURI("/tmp/folder").getRootPath());
    }
}

