/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlluxioTestDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioTestDirectory.class);
    private static final int MAX_FILE_AGE_HOURS = 1;
    public static final File ALLUXIO_TEST_DIRECTORY = AlluxioTestDirectory.createTestingDirectory();

    public static File createTemporaryDirectory(String prefix) {
        return AlluxioTestDirectory.createTemporaryDirectory(ALLUXIO_TEST_DIRECTORY, prefix);
    }

    public static File createTemporaryDirectory(File parent, String prefix) {
        File file = new File(parent, prefix + "-" + UUID.randomUUID());
        if (!file.mkdirs()) {
            throw new RuntimeException("Failed to create directory " + file.getAbsolutePath());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> AlluxioTestDirectory.delete(file)));
        return file;
    }

    private static File createTestingDirectory() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "alluxio-tests");
        if (tmpDir.exists()) {
            AlluxioTestDirectory.cleanUpOldFiles(tmpDir);
        }
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            throw new RuntimeException("Failed to create testing directory " + tmpDir.getAbsolutePath());
        }
        return tmpDir;
    }

    private static void cleanUpOldFiles(File dir) {
        long cutoffTimestamp = System.currentTimeMillis() - 3600000L;
        Arrays.asList(dir.listFiles()).stream().filter(file -> !FileUtils.isFileNewer((File)file, (long)cutoffTimestamp)).forEach(AlluxioTestDirectory::delete);
    }

    private static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            LOG.warn("Failed to clean up {} : {}", (Object)file.getAbsolutePath(), (Object)e.toString());
        }
    }
}

